/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.data.remove;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.expression.evaluator.description.DescriptionExpressionEvaluatorFactory;
import org.gcube.data.analysis.tabulardata.expression.evaluator.sql.SQLExpressionEvaluatorFactory;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.OperationHelper;
import org.gcube.data.analysis.tabulardata.operation.OperationId;
import org.gcube.data.analysis.tabulardata.operation.data.remove.FilterByExpression;
import org.gcube.data.analysis.tabulardata.operation.data.remove.RowRecoveryRollbackWorker;
import org.gcube.data.analysis.tabulardata.operation.factories.types.TableTransformationWorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.Cardinality;
import org.gcube.data.analysis.tabulardata.operation.parameters.LeafParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.Parameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.ExpressionParameter;
import org.gcube.data.analysis.tabulardata.operation.validation.ValidateDataWithExpressionFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.RollbackWorker;
import org.gcube.data.analysis.tabulardata.operation.worker.Worker;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;

@Singleton
public class FilterByExpressionFactory
extends TableTransformationWorkerFactory {
    private static final OperationId OPERATION_ID = new OperationId(3201L);
    public static final ExpressionParameter EXPRESSION_PARAMETER = new ExpressionParameter("expression", "Expression", "Filter condition", Cardinality.ONE);
    private CubeManager cubeManager;
    private DatabaseConnectionProvider connectionProvider;
    private SQLExpressionEvaluatorFactory sqlEvaluatorFactory;
    private ValidateDataWithExpressionFactory validateDataWithExpressionFactory;
    private DescriptionExpressionEvaluatorFactory descriptionEvaluatorFactory;

    @Inject
    public FilterByExpressionFactory(CubeManager cubeManager, DatabaseConnectionProvider connectionProvider, SQLExpressionEvaluatorFactory sqlEvaluatorFactory, DescriptionExpressionEvaluatorFactory descriptionEvaluatorFactory, ValidateDataWithExpressionFactory validateDataWithExpressionFactory) {
        this.cubeManager = cubeManager;
        this.connectionProvider = connectionProvider;
        this.sqlEvaluatorFactory = sqlEvaluatorFactory;
        this.validateDataWithExpressionFactory = validateDataWithExpressionFactory;
        this.descriptionEvaluatorFactory = descriptionEvaluatorFactory;
    }

    public Worker createWorker(OperationInvocation invocation) throws InvalidInvocationException {
        this.performBaseChecks(invocation, this.cubeManager);
        return new FilterByExpression(invocation, this.cubeManager, this.connectionProvider, this.sqlEvaluatorFactory, this.validateDataWithExpressionFactory);
    }

    public RollbackWorker createRollbackWoker(Table diffTable, Table createdTable, OperationInvocation oldInvocation) {
        return new RowRecoveryRollbackWorker(diffTable, createdTable, oldInvocation, this.cubeManager, this.connectionProvider);
    }

    public boolean isRollbackable() {
        return true;
    }

    protected String getOperationDescription() {
        return "Delete rows that doesn't match the given expression from the target table";
    }

    protected String getOperationName() {
        return "Filter by Expression";
    }

    protected List<Parameter> getParameters() {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add((Parameter)EXPRESSION_PARAMETER);
        return parameters;
    }

    protected OperationId getOperationId() {
        return OPERATION_ID;
    }

    public String describeInvocation(OperationInvocation toDescribeInvocation) throws InvalidInvocationException {
        this.performBaseChecks(toDescribeInvocation, this.cubeManager);
        Expression expr = (Expression)OperationHelper.getParameter((LeafParameter)EXPRESSION_PARAMETER, (OperationInvocation)toDescribeInvocation);
        return String.format("Remove rows not satisfying condition %s.", this.descriptionEvaluatorFactory.getEvaluator(expr).evaluate());
    }
}

