/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.data.replace;

import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.expression.MalformedExpressionException;
import org.gcube.data.analysis.tabulardata.expression.composite.comparable.Equals;
import org.gcube.data.analysis.tabulardata.expression.evaluator.sql.SQLExpressionEvaluatorFactory;
import org.gcube.data.analysis.tabulardata.expression.leaf.TypedColumnReference;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.type.IdColumnType;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDInteger;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDTypeValue;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.SQLHelper;
import org.gcube.data.analysis.tabulardata.operation.data.replace.ReplaceByIdFactory;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.worker.ImmutableWorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.Worker;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;

public class ReplaceById
extends Worker {
    private CubeManager cubeManager;
    private DatabaseConnectionProvider connectionProvider;
    private SQLExpressionEvaluatorFactory sqlEvaluatorFactory;
    private Table targetTable;
    private Column targetColumn;
    private TDTypeValue value;
    private Integer rowId;
    private Table newTable;
    private Table diffTable;

    public ReplaceById(OperationInvocation sourceInvocation, CubeManager cubeManager, DatabaseConnectionProvider connectionProvider, SQLExpressionEvaluatorFactory sqlEvaluatorFactory) {
        super(sourceInvocation);
        this.cubeManager = cubeManager;
        this.connectionProvider = connectionProvider;
        this.sqlEvaluatorFactory = sqlEvaluatorFactory;
    }

    protected WorkerResult execute() throws WorkerException {
        try {
            this.instantiateExecutionVariables();
            this.updateProgress(0.1f, "Initializing");
            this.newTable = this.cubeManager.createTable(this.targetTable.getTableType()).like(this.targetTable, true).create();
            this.diffTable = this.cubeManager.createTable(this.targetTable.getTableType()).addColumn(this.targetColumn).create();
            this.updateProgress(0.5f, "Updating");
            this.executeBatch();
            this.updateProgress(0.9f, "Finalizing");
            return new ImmutableWorkerResult(this.newTable, this.diffTable);
        }
        catch (MalformedExpressionException e) {
            throw new WorkerException("Passed value is not well formed", (Throwable)e);
        }
    }

    private void instantiateExecutionVariables() throws WorkerException, MalformedExpressionException {
        OperationInvocation invocation = this.getSourceInvocation();
        this.targetTable = this.cubeManager.getTable(invocation.getTargetTableId());
        this.targetColumn = this.targetTable.getColumnById(invocation.getTargetColumnId());
        this.value = (TDTypeValue)invocation.getParameterInstances().get(ReplaceByIdFactory.VALUE.getIdentifier());
        if (!this.value.getReturnedDataType().getClass().isAssignableFrom(this.targetColumn.getDataType().getClass())) {
            throw new WorkerException("Target column and passed value has incompatible types");
        }
        this.rowId = (Integer)invocation.getParameterInstances().get(ReplaceByIdFactory.ID.getIdentifier());
    }

    private void executeBatch() throws WorkerException {
        try {
            SQLHelper.executeSQLBatchCommands((DatabaseConnectionProvider)this.connectionProvider, (String[])new String[]{this.getUpdateStatement()});
        }
        catch (Exception e) {
            throw new WorkerException("Error occurred while executing SQL command", (Throwable)e);
        }
    }

    private String getUpdateStatement() {
        TypedColumnReference idColumnReference = this.newTable.getColumnReference((Column)this.newTable.getColumnsByType(new Class[]{IdColumnType.class}).get(0));
        return String.format("WITH updated AS (UPDATE %1$s SET %2$s = %3$s WHERE %4$s RETURNING id)  INSERT INTO %5$s (id, %2$s) SELECT target.id, target.%2$s FROM %6$s as target, updated WHERE updated.id = target.id ", this.newTable.getName(), this.targetColumn.getName(), this.sqlEvaluatorFactory.getEvaluator((Expression)this.value).evaluate(), this.sqlEvaluatorFactory.getEvaluator((Expression)new Equals((Expression)idColumnReference, (Expression)new TDInteger(this.rowId))).evaluate(), this.diffTable.getName(), this.targetTable.getName());
    }
}

