/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.data.remove;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.type.IdColumnType;
import org.gcube.data.analysis.tabulardata.model.metadata.table.GenericMapMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.TableMetadata;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;
import org.gcube.data.analysis.tabulardata.operation.worker.results.ImmutableWorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.results.WorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.types.DataWorker;

public class RemoveColumn
extends DataWorker {
    private CubeManager cubeManager;
    protected static final String METADATA_AFTER_KEY = "after";
    protected static final String METADATA_BEFORE_KEY = "before";
    private Table targetTable;
    private Table diffTable;
    private Column targetColumn;

    public RemoveColumn(CubeManager cubeManager, OperationInvocation invocation) {
        super(invocation);
        this.cubeManager = cubeManager;
        this.targetTable = cubeManager.getTable(invocation.getTargetTableId());
        this.targetColumn = this.targetTable.getColumnById(invocation.getTargetColumnId());
    }

    protected WorkerResult execute() throws WorkerException {
        this.updateProgress(0.1f, "Removing column..");
        Table resultTable = this.cubeManager.createTable(this.targetTable.getTableType()).like(this.targetTable, true, (List)Lists.newArrayList((Object[])new Column[]{this.targetColumn})).create();
        ArrayList<Column> columns = new ArrayList<Column>();
        for (Column column : this.targetTable.getColumnsExceptTypes(new Class[]{IdColumnType.class})) {
            if (column == this.targetColumn) continue;
            columns.add(column);
        }
        List allColumnExceptId = this.targetTable.getColumnsExceptTypes(new Class[]{IdColumnType.class});
        int targetColumnIndex = allColumnExceptId.indexOf(this.targetColumn);
        HashMap<String, String> genericMap = new HashMap<String, String>(2);
        if (targetColumnIndex > 0) {
            genericMap.put(METADATA_AFTER_KEY, ((Column)allColumnExceptId.get(targetColumnIndex - 1)).getLocalId().getValue());
        }
        if (targetColumnIndex < allColumnExceptId.size() - 1) {
            genericMap.put(METADATA_BEFORE_KEY, ((Column)allColumnExceptId.get(targetColumnIndex + 1)).getLocalId().getValue());
        }
        GenericMapMetadata mapMetadata = new GenericMapMetadata(genericMap);
        this.diffTable = this.cubeManager.createTable(this.targetTable.getTableType()).like(this.targetTable, true, columns).create();
        this.diffTable = this.cubeManager.modifyTableMeta(this.diffTable.getId()).setTableMetadata(new TableMetadata[]{mapMetadata}).create();
        this.updateProgress(0.9f, "Finalizing");
        return new ImmutableWorkerResult(resultTable, this.diffTable);
    }
}

