/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.data.transformation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.expression.evaluator.sql.SQLExpressionEvaluatorFactory;
import org.gcube.data.analysis.tabulardata.expression.functions.Cast;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.column.ColumnType;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDTypeValue;
import org.gcube.data.analysis.tabulardata.model.metadata.column.ColumnMetadata;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.type.CodelistTableType;
import org.gcube.data.analysis.tabulardata.operation.OperationHelper;
import org.gcube.data.analysis.tabulardata.operation.OperationId;
import org.gcube.data.analysis.tabulardata.operation.data.transformation.ExtractCodelist;
import org.gcube.data.analysis.tabulardata.operation.factories.types.TableTransformationWorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.Cardinality;
import org.gcube.data.analysis.tabulardata.operation.parameters.CompositeParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.Parameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.ColumnMetadataParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.ColumnTypeParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.TDTypeValueParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.TargetColumnParameter;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;
import org.gcube.data.analysis.tabulardata.operation.worker.types.DataWorker;

@Singleton
public class ExtractCodelistFactory
extends TableTransformationWorkerFactory {
    private static final OperationId OPERATION_ID = new OperationId(11001L);
    public static TargetColumnParameter SOURCE_COLUMN = new TargetColumnParameter("source", "Source column", "Column to export", Cardinality.ONE);
    public static ColumnTypeParameter COLUMN_TYPE_PARAMETER = new ColumnTypeParameter("column_type", "Column type", "Column type", Cardinality.ONE, new CodelistTableType().getAllowedColumnTypes());
    public static ColumnMetadataParameter METADATA_PARAMETER = new ColumnMetadataParameter("metadata", "Metadata", "To set metadata", new Cardinality(0, Integer.MAX_VALUE));
    public static TDTypeValueParameter DEFAULT_VALUE_PARAMETER = new TDTypeValueParameter("default", "Default value", "Default value", Cardinality.OPTIONAL);
    public static CompositeParameter COLUMN_DEFINITION = new CompositeParameter("column_definition", "Column definition", "New Column Definition", Cardinality.OPTIONAL, Arrays.asList(COLUMN_TYPE_PARAMETER, METADATA_PARAMETER, DEFAULT_VALUE_PARAMETER));
    public static TargetColumnParameter TARGET_CODE_COLUMN = new TargetColumnParameter("target_code_column", "Target code column", "The code column to which exctracted values must be added", Cardinality.OPTIONAL, Collections.singletonList(new CodelistTableType()), new CodelistTableType().getAllowedColumnTypes());
    public static CompositeParameter COLUMN_MAPPING = new CompositeParameter("mapping", "Column mapping", "Additional columns to export", new Cardinality(1, Integer.MAX_VALUE), Arrays.asList(SOURCE_COLUMN, TARGET_CODE_COLUMN, COLUMN_DEFINITION));
    private List<Parameter> parameters = Collections.singletonList(COLUMN_MAPPING);
    CubeManager cubeManager;
    DatabaseConnectionProvider connectionProvider;
    SQLExpressionEvaluatorFactory sqlExpressionEvaluatorFactory;

    @Inject
    public ExtractCodelistFactory(CubeManager cubeManager, DatabaseConnectionProvider connectionProvider, SQLExpressionEvaluatorFactory sqlExpressionEvaluatorFactory) {
        this.cubeManager = cubeManager;
        this.connectionProvider = connectionProvider;
        this.sqlExpressionEvaluatorFactory = sqlExpressionEvaluatorFactory;
    }

    protected String getOperationDescription() {
        return "Extract distinct values from the target column and puts them in the selected codelist or a new one.";
    }

    protected String getOperationName() {
        return "Extract codelist";
    }

    protected OperationId getOperationId() {
        return OPERATION_ID;
    }

    protected List<Parameter> getParameters() {
        return this.parameters;
    }

    public DataWorker createWorker(OperationInvocation invocation) throws InvalidInvocationException {
        this.performBaseChecks(invocation, this.cubeManager);
        this.checkParametersValidity(invocation);
        return new ExtractCodelist(invocation, this.cubeManager, this.connectionProvider, this.sqlExpressionEvaluatorFactory);
    }

    private void checkParametersValidity(OperationInvocation invocation) throws InvalidInvocationException {
        Map<ColumnReference, ColumnMapping> mappings = ExtractCodelistFactory.getMapping(invocation);
        Table targetCodelist = null;
        Table targetTable = this.cubeManager.getTable(invocation.getTargetTableId());
        for (Map.Entry<ColumnReference, ColumnMapping> entry : mappings.entrySet()) {
            ColumnMapping target = entry.getValue();
            DataType sourceDataType = targetTable.getColumnById(entry.getKey().getColumnId()).getDataType();
            DataType targetDataType = null;
            if (!target.isCreateNewColumn()) {
                if (targetCodelist == null) {
                    targetCodelist = this.cubeManager.getTable(target.getTargetColumn().getTableId());
                } else if (!targetCodelist.getId().equals((Object)target.getTargetColumn().getTableId())) {
                    throw new InvalidInvocationException(invocation, "Target columns must refer to the same codelist");
                }
                targetDataType = targetCodelist.getColumnById(target.getTargetColumn().getColumnId()).getDataType();
            } else {
                targetDataType = target.getDefaultValue().getReturnedDataType();
            }
            if (Cast.isCastSupported((DataType)sourceDataType, (DataType)targetDataType)) continue;
            throw new InvalidInvocationException(invocation, String.format("Cast not supported from %s to %s", sourceDataType, targetDataType));
        }
    }

    public String describeInvocation(OperationInvocation invocation) throws InvalidInvocationException {
        this.performBaseChecks(invocation, this.cubeManager);
        this.checkParametersValidity(invocation);
        Map<ColumnReference, ColumnMapping> mappings = ExtractCodelistFactory.getMapping(invocation);
        Table targetTable = this.cubeManager.getTable(invocation.getTargetTableId());
        ArrayList<Column> sourceColumns = new ArrayList<Column>();
        for (Map.Entry<ColumnReference, ColumnMapping> entry : mappings.entrySet()) {
            sourceColumns.add(targetTable.getColumnById(entry.getKey().getColumnId()));
            if (entry.getValue().isCreateNewColumn()) continue;
            Table targetCodelist = this.cubeManager.getTable(entry.getValue().getTargetColumn().getTableId());
            return String.format("Add values to %s", OperationHelper.retrieveTableLabel((Table)targetCodelist));
        }
        return String.format("Create codelist from ", OperationHelper.getColumnLabelsSnippet(sourceColumns));
    }

    static Map<ColumnReference, ColumnMapping> getMapping(OperationInvocation invocation) throws InvalidInvocationException {
        Object mappingObject = invocation.getParameterInstances().get(COLUMN_MAPPING.getIdentifier());
        try {
            if (mappingObject instanceof Map) {
                return ExtractCodelistFactory.getColumnMapping((Map)mappingObject);
            }
            HashMap<ColumnReference, ColumnMapping> toReturn = new HashMap<ColumnReference, ColumnMapping>();
            for (Map singleMapping : (Iterable)mappingObject) {
                toReturn.putAll(ExtractCodelistFactory.getColumnMapping(singleMapping));
            }
            return toReturn;
        }
        catch (Exception e) {
            throw new InvalidInvocationException(invocation, e);
        }
    }

    private static Map<ColumnReference, ColumnMapping> getColumnMapping(Map<String, Object> mapping) throws Exception {
        ColumnReference sourceColumn = (ColumnReference)mapping.get(SOURCE_COLUMN.getIdentifier());
        ColumnMapping target = null;
        if (mapping.containsKey(TARGET_CODE_COLUMN.getIdentifier())) {
            target = new ColumnMapping((ColumnReference)mapping.get(TARGET_CODE_COLUMN.getIdentifier()));
        } else if (mapping.containsKey(COLUMN_DEFINITION.getIdentifier())) {
            Map colDefinition = (Map)mapping.get(COLUMN_DEFINITION.getIdentifier());
            ColumnType colType = (ColumnType)colDefinition.get(COLUMN_TYPE_PARAMETER.getIdentifier());
            TDTypeValue defaultValue = (TDTypeValue)(colDefinition.containsKey(DEFAULT_VALUE_PARAMETER.getIdentifier()) ? colDefinition.get(DEFAULT_VALUE_PARAMETER.getIdentifier()) : colType.getDefaultDataType());
            ArrayList<ColumnMetadata> meta = new ArrayList<ColumnMetadata>();
            if (colDefinition.containsKey(METADATA_PARAMETER.getIdentifier())) {
                Object metaObject = colDefinition.get(METADATA_PARAMETER.getIdentifier());
                if (metaObject instanceof ColumnMetadata) {
                    meta.add((ColumnMetadata)metaObject);
                } else {
                    for (ColumnMetadata colMeta : (Iterable)metaObject) {
                        meta.add(colMeta);
                    }
                }
            }
            target = new ColumnMapping(colType, meta, defaultValue);
        } else {
            throw new Exception(String.format("No target column / new column definition provided for source column %s.", sourceColumn));
        }
        return Collections.singletonMap(sourceColumn, target);
    }

    public static class ColumnMapping {
        private boolean createNewColumn = false;
        private ColumnReference targetColumn = null;
        private ColumnType columnType = null;
        private List<ColumnMetadata> columnMetadata = null;
        private TDTypeValue defaultValue = null;

        public ColumnMapping(ColumnReference targetColumn) {
            this.targetColumn = targetColumn;
        }

        public ColumnMapping(ColumnType columnType, List<ColumnMetadata> columnMetadata, TDTypeValue defaultValue) {
            this.columnType = columnType;
            this.columnMetadata = columnMetadata;
            this.defaultValue = defaultValue;
            this.createNewColumn = true;
        }

        public boolean isCreateNewColumn() {
            return this.createNewColumn;
        }

        public ColumnReference getTargetColumn() {
            return this.targetColumn;
        }

        public ColumnType getColumnType() {
            return this.columnType;
        }

        public List<ColumnMetadata> getColumnMetadata() {
            return this.columnMetadata;
        }

        public TDTypeValue getDefaultValue() {
            return this.defaultValue;
        }
    }
}

