/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.data.transformation;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.cube.tablemanagers.TableCreator;
import org.gcube.data.analysis.tabulardata.expression.evaluator.sql.SQLExpressionEvaluatorFactory;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.column.type.IdColumnType;
import org.gcube.data.analysis.tabulardata.model.metadata.common.LocalizedText;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.SQLHelper;
import org.gcube.data.analysis.tabulardata.operation.data.transformation.AggregationFunction;
import org.gcube.data.analysis.tabulardata.operation.data.transformation.GroupByFactory;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;
import org.gcube.data.analysis.tabulardata.operation.worker.results.ImmutableWorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.results.WorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.types.DataWorker;

public class GroupBy
extends DataWorker {
    CubeManager cubeManager;
    DatabaseConnectionProvider connectionProvider;
    SQLExpressionEvaluatorFactory sqlEvaluator;
    private List<Column> groupByColumns = new ArrayList<Column>();
    private Map<Column, AggregationFunction> toApplyAggregations = new HashMap<Column, AggregationFunction>();
    private Table targetTable;
    private Table newTable;

    public GroupBy(OperationInvocation sourceInvocation, CubeManager cubeManager, DatabaseConnectionProvider connectionProvider, SQLExpressionEvaluatorFactory sqlEvaluator) {
        super(sourceInvocation);
        this.cubeManager = cubeManager;
        this.connectionProvider = connectionProvider;
        this.sqlEvaluator = sqlEvaluator;
    }

    protected WorkerResult execute() throws WorkerException {
        this.retrieveParameters();
        this.updateProgress(0.1f, "Initializing");
        this.updateProgress(0.2f, "Analyzing structure");
        String query = this.formQuery();
        this.updateProgress(0.3f, "Creating grouped data");
        this.executeSQLCommand(query);
        this.updateProgress(0.9f, "Finalizing");
        return new ImmutableWorkerResult(this.newTable);
    }

    private void retrieveParameters() {
        OperationInvocation invocation = this.getSourceInvocation();
        this.targetTable = this.cubeManager.getTable(invocation.getTargetTableId());
        Object toAggregateObj = invocation.getParameterInstances().get(GroupByFactory.GROUPBY_COLUMNS.getIdentifier());
        if (toAggregateObj instanceof Iterable) {
            for (Object ref : (Iterable)toAggregateObj) {
                this.groupByColumns.add(this.targetTable.getColumnById(((ColumnReference)ref).getColumnId()));
            }
        } else {
            this.groupByColumns.add(this.targetTable.getColumnById(((ColumnReference)toAggregateObj).getColumnId()));
        }
        if (invocation.getParameterInstances().containsKey(GroupByFactory.AGGREGATE_FUNCTION_TO_APPLY.getIdentifier())) {
            Object compositeObj = invocation.getParameterInstances().get(GroupByFactory.AGGREGATE_FUNCTION_TO_APPLY.getIdentifier());
            if (compositeObj instanceof Iterable) {
                for (Object mapObj : (Iterable)compositeObj) {
                    this.insertCompositeParameterValues((Map)mapObj);
                }
            } else {
                this.insertCompositeParameterValues((Map)compositeObj);
            }
        }
        TableCreator tc = this.cubeManager.createTable(this.targetTable.getTableType()).like(this.targetTable, false);
        for (Column col : this.targetTable.getColumnsExceptTypes(new Class[]{IdColumnType.class})) {
            if (this.groupByColumns.contains(col) || this.toApplyAggregations.containsKey(col)) continue;
            tc.removeColumn(col);
        }
        this.newTable = tc.create();
    }

    private void insertCompositeParameterValues(Map<String, Object> composite) {
        ColumnReference ref = (ColumnReference)composite.get(GroupByFactory.TO_AGGREGATE_COLUMNS.getIdentifier());
        AggregationFunction function = AggregationFunction.valueOf(((LocalizedText)composite.get(GroupByFactory.FUNCTION_PARAMETER.getIdentifier())).getValue());
        this.toApplyAggregations.put(this.targetTable.getColumnById(ref.getColumnId()), function);
    }

    private String formQuery() throws WorkerException {
        StringBuilder theQuery = new StringBuilder();
        theQuery.append(String.format("INSERT INTO %s ", this.newTable.getName()));
        theQuery.append("(" + this.insertColumnsList() + ")");
        StringBuilder keyCSVList = new StringBuilder();
        for (Column column : this.groupByColumns) {
            keyCSVList.append(String.valueOf(column.getName()) + ",");
        }
        keyCSVList.deleteCharAt(keyCSVList.lastIndexOf(","));
        theQuery.append(" SELECT ");
        theQuery.append(keyCSVList + ",");
        for (Map.Entry entry : this.toApplyAggregations.entrySet()) {
            theQuery.append(String.valueOf(this.getSQLFunction((Column)entry.getKey(), (AggregationFunction)((Object)entry.getValue()))) + ",");
        }
        theQuery.deleteCharAt(theQuery.lastIndexOf(","));
        theQuery.append(String.format("FROM %s GROUP BY %s", this.targetTable.getName(), keyCSVList.toString()));
        return theQuery.toString();
    }

    private String insertColumnsList() {
        StringBuilder toReturn = new StringBuilder();
        for (Column col : this.groupByColumns) {
            toReturn.append(String.valueOf(col.getName()) + ",");
        }
        for (Column col : this.toApplyAggregations.keySet()) {
            toReturn.append(String.valueOf(col.getName()) + ",");
        }
        toReturn.deleteCharAt(toReturn.lastIndexOf(","));
        return toReturn.toString();
    }

    private String getSQLFunction(Column col, AggregationFunction func) {
        return String.format("%s(%s)", new Object[]{func, col.getName()});
    }

    private void executeSQLCommand(String theQuery) throws WorkerException {
        try {
            SQLHelper.executeSQLBatchCommands((DatabaseConnectionProvider)this.connectionProvider, (String[])new String[]{theQuery});
        }
        catch (SQLException e) {
            throw new WorkerException("Unable to execute sql command, see previous log.", (Throwable)e);
        }
    }
}

