/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.data.transformation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.expression.evaluator.sql.SQLExpressionEvaluatorFactory;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.metadata.common.ImmutableLocalizedText;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.operation.OperationHelper;
import org.gcube.data.analysis.tabulardata.operation.OperationId;
import org.gcube.data.analysis.tabulardata.operation.data.transformation.AggregationFunction;
import org.gcube.data.analysis.tabulardata.operation.data.transformation.GroupBy;
import org.gcube.data.analysis.tabulardata.operation.factories.types.TableTransformationWorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.Cardinality;
import org.gcube.data.analysis.tabulardata.operation.parameters.CompositeParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.Parameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.LocalizedTextChoiceParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.TargetColumnParameter;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;
import org.gcube.data.analysis.tabulardata.operation.worker.types.DataWorker;

@Singleton
public class GroupByFactory
extends TableTransformationWorkerFactory {
    private static final OperationId OPERATION_ID = new OperationId(3006L);
    CubeManager cubeManager;
    DatabaseConnectionProvider connectionProvider;
    SQLExpressionEvaluatorFactory sqlExpressionEvaluatorFactory;
    public static TargetColumnParameter GROUPBY_COLUMNS = new TargetColumnParameter("groupByColumns", "Group By Columns", "Columns to use as a key of grouping", new Cardinality(1, Integer.MAX_VALUE));
    public static LocalizedTextChoiceParameter FUNCTION_PARAMETER = new LocalizedTextChoiceParameter("functionParameter", "Function Parameter", "Aggregation function to apply", Cardinality.ONE, Arrays.asList(new ImmutableLocalizedText((Object)((Object)AggregationFunction.AVG) + ""), new ImmutableLocalizedText((Object)((Object)AggregationFunction.COUNT) + ""), new ImmutableLocalizedText((Object)((Object)AggregationFunction.MAX) + ""), new ImmutableLocalizedText((Object)((Object)AggregationFunction.MIN) + ""), new ImmutableLocalizedText((Object)((Object)AggregationFunction.SUM) + "")));
    public static TargetColumnParameter TO_AGGREGATE_COLUMNS = new TargetColumnParameter("functionMember", "To Aggregate values", "Aggregation function member", Cardinality.ONE);
    public static CompositeParameter AGGREGATE_FUNCTION_TO_APPLY = new CompositeParameter("aggregationFunctions", "Aggregation Functions", "Aggregation Function to apply", new Cardinality(1, Integer.MAX_VALUE), Arrays.asList(FUNCTION_PARAMETER, TO_AGGREGATE_COLUMNS));
    private List<Parameter> parameters = Arrays.asList(GROUPBY_COLUMNS, AGGREGATE_FUNCTION_TO_APPLY);

    public DataWorker createWorker(OperationInvocation arg0) throws InvalidInvocationException {
        this.performBaseChecks(arg0, this.cubeManager);
        this.checkParameters(arg0);
        return new GroupBy(arg0, this.cubeManager, this.connectionProvider, this.sqlExpressionEvaluatorFactory);
    }

    private void checkParameters(OperationInvocation invocation) throws InvalidInvocationException {
        Object compositeObj;
        TableId targetTableId = invocation.getTargetTableId();
        Object toAggregateObj = invocation.getParameterInstances().get(GROUPBY_COLUMNS.getIdentifier());
        if (toAggregateObj instanceof Iterable) {
            Iterable cols = (Iterable)toAggregateObj;
            for (ColumnReference ref : cols) {
                if (ref.getTableId().equals((Object)targetTableId)) continue;
                throw new InvalidInvocationException(invocation, "Inconsistent target table and aggregation column references");
            }
        } else if (!((ColumnReference)toAggregateObj).getTableId().equals((Object)targetTableId)) {
            throw new InvalidInvocationException(invocation, "Inconsistent target table and aggregation column references");
        }
        if ((compositeObj = invocation.getParameterInstances().get(AGGREGATE_FUNCTION_TO_APPLY.getIdentifier())) instanceof Iterable) {
            for (Object mapObj : (Iterable)compositeObj) {
                if (((ColumnReference)((Map)mapObj).get(TO_AGGREGATE_COLUMNS.getIdentifier())).getTableId().equals((Object)targetTableId)) continue;
                throw new InvalidInvocationException(invocation, "Inconsistent target table and to aggregate values column references");
            }
        } else if (!((ColumnReference)((Map)compositeObj).get(TO_AGGREGATE_COLUMNS.getIdentifier())).getTableId().equals((Object)targetTableId)) {
            throw new InvalidInvocationException(invocation, "Inconsistent target table and to aggregate values column references");
        }
    }

    public String describeInvocation(OperationInvocation invocation) throws InvalidInvocationException {
        this.performBaseChecks(invocation, this.cubeManager);
        this.checkParameters(invocation);
        ArrayList<Column> groupByColumns = new ArrayList<Column>();
        Object toAggregateObj = invocation.getParameterInstances().get(GROUPBY_COLUMNS.getIdentifier());
        if (toAggregateObj instanceof Iterable) {
            Iterable cols = (Iterable)toAggregateObj;
            for (ColumnReference ref : cols) {
                groupByColumns.add(this.cubeManager.getTable(ref.getTableId()).getColumnById(ref.getColumnId()));
            }
        } else {
            ColumnReference ref = (ColumnReference)toAggregateObj;
            groupByColumns.add(this.cubeManager.getTable(ref.getTableId()).getColumnById(ref.getColumnId()));
        }
        return String.format("Group by %s", OperationHelper.getColumnLabelsSnippet(groupByColumns));
    }

    @Inject
    public GroupByFactory(CubeManager cubeManager, DatabaseConnectionProvider connectionProvider, SQLExpressionEvaluatorFactory sqlExpressionEvaluatorFactory) {
        this.cubeManager = cubeManager;
        this.connectionProvider = connectionProvider;
        this.sqlExpressionEvaluatorFactory = sqlExpressionEvaluatorFactory;
    }

    protected String getOperationDescription() {
        return "Group rows by selected keys, applying the specified aggregation functions to relative selected member columns";
    }

    protected String getOperationName() {
        return "Group by";
    }

    protected List<Parameter> getParameters() {
        return this.parameters;
    }

    protected OperationId getOperationId() {
        return OPERATION_ID;
    }
}

