/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.data.transformation;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.cube.tablemanagers.TableCreator;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.expression.evaluator.sql.SQLExpressionEvaluatorFactory;
import org.gcube.data.analysis.tabulardata.expression.functions.Cast;
import org.gcube.data.analysis.tabulardata.expression.logical.IsNull;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.column.factories.AttributeColumnFactory;
import org.gcube.data.analysis.tabulardata.model.column.type.IdColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.ValidationColumnType;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.datatype.TextType;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDText;
import org.gcube.data.analysis.tabulardata.model.metadata.common.ImmutableLocalizedText;
import org.gcube.data.analysis.tabulardata.model.metadata.common.LocalizedText;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.OperationHelper;
import org.gcube.data.analysis.tabulardata.operation.SQLHelper;
import org.gcube.data.analysis.tabulardata.operation.data.transformation.NormalizationFactory;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.LeafParameter;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.OperationAbortedException;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;
import org.gcube.data.analysis.tabulardata.operation.worker.results.ImmutableWorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.results.WorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.types.DataWorker;

public class NormalizationWorker
extends DataWorker {
    private CubeManager cubeManager;
    private SQLExpressionEvaluatorFactory evaluatorFactory;
    private DatabaseConnectionProvider connProvider;
    private Table targetTable;
    private ArrayList<Column> toNormalize = new ArrayList();
    private Table newTable;
    private Column normalizedColumn;
    private Column quantity;

    public NormalizationWorker(OperationInvocation sourceInvocation, CubeManager cubeManager, SQLExpressionEvaluatorFactory evaluatorFactory, DatabaseConnectionProvider connProvider) {
        super(sourceInvocation);
        this.cubeManager = cubeManager;
        this.evaluatorFactory = evaluatorFactory;
        this.connProvider = connProvider;
    }

    protected WorkerResult execute() throws WorkerException, OperationAbortedException {
        try {
            this.init();
            this.updateProgress(0.1f, "Creating new table structure");
            this.checkAborted();
            this.createTable();
            this.updateProgress(0.3f, "Transferring data into new structure");
            this.checkAborted();
            this.executeScripts();
            this.updateProgress(0.9f, "Finalizing");
            return new ImmutableWorkerResult(this.newTable);
        }
        catch (InvalidInvocationException e) {
            throw new WorkerException("Unexpected Error while parsing invocation", (Throwable)e);
        }
    }

    private void init() throws InvalidInvocationException {
        this.targetTable = this.cubeManager.getTable(this.getSourceInvocation().getTargetTableId());
        for (ColumnReference ref : NormalizationFactory.getColumns(this.getSourceInvocation())) {
            this.toNormalize.add(this.targetTable.getColumnById(ref.getColumnId()));
        }
    }

    private void createTable() {
        this.createColumnsDefinition();
        TableCreator tc = this.cubeManager.createTable(this.targetTable.getTableType()).like(this.targetTable, false);
        for (Column c : this.toNormalize) {
            tc.removeColumn(c);
        }
        tc.addColumn(this.normalizedColumn);
        tc.addColumn(this.quantity);
        this.newTable = tc.create();
    }

    private void createColumnsDefinition() {
        Object quantityType = null;
        for (Column col : this.toNormalize) {
            if (quantityType == null) {
                quantityType = col.getDataType();
            } else if (!Cast.isCastSupported((DataType)col.getDataType(), (DataType)quantityType)) {
                quantityType = Cast.isCastSupported((DataType)quantityType, (DataType)col.getDataType()) ? col.getDataType() : new TextType();
            }
            if (quantityType instanceof TextType) break;
        }
        Object quantitytLabel = null;
        quantitytLabel = this.getSourceInvocation().getParameterInstances().containsKey(NormalizationFactory.QUANTITY_LABEL.getIdentifier()) ? (LocalizedText)OperationHelper.getParameter((LeafParameter)NormalizationFactory.QUANTITY_LABEL, (OperationInvocation)this.getSourceInvocation()) : new ImmutableLocalizedText("Quantity");
        this.quantity = new AttributeColumnFactory().create(quantityType, Collections.singletonList(quantitytLabel));
        Object normalizedLabel = null;
        normalizedLabel = this.getSourceInvocation().getParameterInstances().containsKey(NormalizationFactory.NORMALIZED_LABEL.getIdentifier()) ? (LocalizedText)OperationHelper.getParameter((LeafParameter)NormalizationFactory.NORMALIZED_LABEL, (OperationInvocation)this.getSourceInvocation()) : new ImmutableLocalizedText("Normalized");
        this.normalizedColumn = new AttributeColumnFactory().create((DataType)new TextType(), Collections.singletonList(normalizedLabel));
    }

    private void executeScripts() throws WorkerException, OperationAbortedException {
        ArrayList<String> scripts = this.getSqlCommands();
        try {
            this.checkAborted();
            SQLHelper.executeSQLBatchCommands((DatabaseConnectionProvider)this.connProvider, (String[])scripts.toArray(new String[scripts.size()]));
        }
        catch (SQLException e) {
            throw new WorkerException("Unable to execute scripts", (Throwable)e);
        }
    }

    private ArrayList<String> getSqlCommands() {
        ArrayList<Column> otherSourceColumns = new ArrayList<Column>();
        ArrayList<Column> otherTargetColumns = new ArrayList<Column>();
        for (Column oldCol : this.targetTable.getColumnsExceptTypes(new Class[]{IdColumnType.class, ValidationColumnType.class})) {
            if (this.toNormalize.contains(oldCol)) continue;
            otherSourceColumns.add(oldCol);
            otherTargetColumns.add(this.newTable.getColumnById(oldCol.getLocalId()));
        }
        ArrayList<String> toReturn = new ArrayList<String>();
        for (Column col : this.toNormalize) {
            String columnLabelValue = (String)this.evaluatorFactory.getEvaluator((Expression)new TDText(OperationHelper.retrieveColumnLabel((Column)col))).evaluate();
            String castedValue = (String)this.evaluatorFactory.getEvaluator((Expression)new Cast((Expression)this.targetTable.getColumnReference(col), this.quantity.getDataType())).evaluate();
            toReturn.add("INSERT INTO " + this.newTable.getName() + " (" + OperationHelper.getColumnNamesSnippet(otherTargetColumns) + "," + this.normalizedColumn.getName() + "," + this.quantity.getName() + ")" + "( SELECT " + OperationHelper.getColumnNamesSnippet(otherSourceColumns) + "," + columnLabelValue + "," + castedValue + " FROM " + this.targetTable.getName() + ")");
        }
        IsNull deleteCondition = new IsNull((Expression)this.newTable.getColumnReference(this.quantity));
        toReturn.add(String.format("DELETE FROM %s where %s", this.newTable.getName(), this.evaluatorFactory.getEvaluator((Expression)deleteCondition).evaluate()));
        return toReturn;
    }
}

