/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.column;

import java.util.List;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.metadata.NoSuchMetadataException;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.exceptions.NoSuchColumnException;
import org.gcube.data.analysis.tabulardata.model.metadata.column.ColumnMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.common.LocalizedText;
import org.gcube.data.analysis.tabulardata.model.metadata.common.NamesMetadata;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.operation.worker.BaseWorker;
import org.gcube.data.analysis.tabulardata.operation.worker.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.OperationException;

public class ChangeLabel
extends BaseWorker {
    private CubeManager cubeManager;
    private LocalizedText labelToChange;
    private LocalizedText newLabel;
    private TableId targetTableId;
    private ColumnLocalId targetColumnId;

    public ChangeLabel(OperationInvocation invocation, CubeManager cubeManager, TableId targetTableId, ColumnLocalId targetColumnId, LocalizedText labelToChange, LocalizedText newLabel) {
        super(invocation);
        this.cubeManager = cubeManager;
        this.labelToChange = labelToChange;
        this.newLabel = newLabel;
        this.targetTableId = targetTableId;
        this.targetColumnId = targetColumnId;
    }

    public void run() {
        this.inProgress(0.1f);
        Table targetTable = this.getTable();
        this.inProgress(0.2f);
        try {
            NamesMetadata namesMeta = this.buildNewMetadata(targetTable);
            this.inProgress(0.3f);
            Table resultTable = this.createNewTable(namesMeta);
            this.succeed(resultTable);
        }
        catch (OperationException e) {
            this.fail(e);
            return;
        }
        catch (Exception e) {
            this.fail(new OperationException(e.getMessage()));
        }
    }

    private Table createNewTable(NamesMetadata namesMeta) {
        return this.cubeManager.modifyTableMeta(this.targetTableId).setColumnMetadata(this.targetColumnId, new ColumnMetadata[]{namesMeta}).create();
    }

    private NamesMetadata buildNewMetadata(Table targetTable) throws OperationException {
        NamesMetadata namesMeta;
        try {
            namesMeta = (NamesMetadata)targetTable.getColumnById(this.targetColumnId).getMetadata(NamesMetadata.class);
        }
        catch (NoSuchColumnException e) {
            throw new OperationException("Unable to locate target column in table");
        }
        catch (NoSuchMetadataException e) {
            throw new OperationException("Column has no label to change");
        }
        List labels = namesMeta.getTexts();
        labels.remove(this.labelToChange);
        labels.add(this.newLabel);
        namesMeta = new NamesMetadata();
        namesMeta.setTexts(labels);
        return namesMeta;
    }

    private Table getTable() {
        return this.cubeManager.getTable(this.targetTableId);
    }
}

