/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.column.typechange;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.cube.tablemanagers.TableCreator;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.IdColumnType;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.datatype.TextType;
import org.gcube.data.analysis.tabulardata.model.metadata.column.ColumnMetadata;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.worker.BaseWorker;
import org.gcube.data.analysis.tabulardata.operation.worker.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.OperationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ChangeColumnTypeTransformation
extends BaseWorker {
    private static final Logger log = LoggerFactory.getLogger(ChangeColumnTypeTransformation.class);
    protected Table targetTable;
    protected Column targetColumn;
    protected CubeManager cubeManager;
    protected DatabaseConnectionProvider databaseConnectionProvider;

    public ChangeColumnTypeTransformation(OperationInvocation invocation, CubeManager cubeManager, DatabaseConnectionProvider databaseConnectionProvider) {
        super(invocation);
        this.cubeManager = cubeManager;
        this.databaseConnectionProvider = databaseConnectionProvider;
        this.targetTable = cubeManager.getTable(invocation.getTargetTableId());
        this.targetColumn = this.targetTable.getColumnById(invocation.getTargetColumnId());
    }

    public void run() {
        try {
            this.inProgress(0.1f);
            Table newTable = this.createNewTable();
            this.inProgress(0.3f);
            String sqlCommand = this.generateSQLFillCommand(this.targetTable, newTable);
            this.inProgress(0.5f);
            this.executeSQLCommand(sqlCommand, this.databaseConnectionProvider);
            this.succeed(newTable);
        }
        catch (OperationException e) {
            this.fail(e);
        }
    }

    private Table createNewTable() {
        TableCreator tableCreator = this.cubeManager.createTable(this.targetTable.getTableType());
        log.debug("Column to remove: " + this.targetColumn);
        tableCreator.like(this.targetTable, false, (List)Lists.newArrayList((Object[])new Column[]{this.targetColumn}));
        Column modifiedColumn = new Column((DataType)new TextType(), this.getManagedColumnType());
        modifiedColumn.setAllMetadata(modifiedColumn.getAllMetadata());
        modifiedColumn.setLocalId(this.targetColumn.getLocalId());
        modifiedColumn.setName(this.targetColumn.getName());
        modifiedColumn.setAllMetadata(this.getMetadataToSet());
        tableCreator.addColumn(modifiedColumn);
        Table newTable = tableCreator.create();
        log.trace("Empty table created:\n" + newTable);
        return newTable;
    }

    protected abstract ColumnType getManagedColumnType();

    private String generateSQLFillCommand(Table sourceTable, Table newTable) {
        StringBuilder sqlBuilder = new StringBuilder();
        List columnsToCopy = newTable.getColumnsExceptTypes(new Class[]{IdColumnType.class});
        String columnNamesSnippet = this.generateColumnNameSnippet(columnsToCopy);
        sqlBuilder.append(String.format("INSERT INTO %s (%s) ", newTable.getName(), columnNamesSnippet));
        sqlBuilder.append(String.format("SELECT %s FROM %s;", columnNamesSnippet, sourceTable.getName()));
        return sqlBuilder.toString();
    }

    private String generateColumnNameSnippet(List<Column> columnsToCopy) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Column column : columnsToCopy) {
            stringBuilder.append(" " + column.getName());
            if (columnsToCopy.indexOf(column) == columnsToCopy.size() - 1) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder.toString();
    }

    protected abstract Collection<ColumnMetadata> getMetadataToSet();
}

