/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.table;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.model.table.TableType;
import org.gcube.data.analysis.tabulardata.operation.factories.types.TableTransformationWorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.parameters.Cardinality;
import org.gcube.data.analysis.tabulardata.operation.parameters.Parameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.MultivaluedStringParameter;
import org.gcube.data.analysis.tabulardata.operation.table.ChangeTableType;
import org.gcube.data.analysis.tabulardata.operation.worker.EligibleOperation;
import org.gcube.data.analysis.tabulardata.operation.worker.OperationDescriptor;
import org.gcube.data.analysis.tabulardata.operation.worker.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.worker.Worker;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.OperationNotEligibleException;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ChangeTableTypeFactory
extends TableTransformationWorkerFactory {
    static final String TABLE_TYPE_PARAMETER_ID = "tableType";
    private static final OperationDescriptor.OperationId OPERATION_ID = new OperationDescriptor.OperationId(1002L);
    private static final List<TableType> availableTableTypes = Lists.newArrayList();
    private static final Logger log = LoggerFactory.getLogger(ChangeTableTypeFactory.class);
    @Inject
    private CubeManager cubeManager;

    static {
        Reflections reflections = new Reflections("org.gcube.data.analysis.tabulardata.model.table", new Scanner[]{new SubTypesScanner()});
        Set classes = reflections.getSubTypesOf(TableType.class);
        for (Class type : classes) {
            String msg = "Unable to instantiate table type";
            try {
                availableTableTypes.add((TableType)type.newInstance());
            }
            catch (InstantiationException e) {
                log.error(msg, (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.error(msg, (Throwable)e);
            }
        }
        log.trace("Loaded available table types: " + availableTableTypes);
    }

    public EligibleOperation getEligibleOperation(TableId tableId) throws OperationNotEligibleException {
        return this.getEligibleOperation(this.cubeManager.getTable(tableId));
    }

    public EligibleOperation getEligibleOperation(Table table) {
        TableType tableType = table.getTableType();
        List<String> admittedValues = this.getAdmittedValues(tableType);
        MultivaluedStringParameter tableTypeParameter = new MultivaluedStringParameter(TABLE_TYPE_PARAMETER_ID, "Table Type", "Table type", Cardinality.ONE, admittedValues);
        ArrayList parameters = Lists.newArrayList((Object[])new Parameter[]{tableTypeParameter});
        return new EligibleOperation(this.getOperationDescriptor(), (List)parameters, table.getId());
    }

    public List<String> getAdmittedValues(TableType tableType) {
        ArrayList admittedValues = Lists.newArrayList();
        for (TableType availableTableType : availableTableTypes) {
            if (availableTableType.equals((Object)tableType)) continue;
            admittedValues.add(availableTableType.getName());
        }
        return admittedValues;
    }

    public Worker createWorker(OperationInvocation invocation) throws InvalidInvocationException {
        this.checkInvocation(invocation);
        Table targetTable = this.cubeManager.getTable(invocation.getTargetTableId());
        String targetTableTypeName = (String)invocation.getParameterInstances().get(TABLE_TYPE_PARAMETER_ID);
        TableType targetTableType = this.getTableType(targetTableTypeName);
        return new ChangeTableType(invocation, this.cubeManager, targetTable, targetTableType);
    }

    public TableType getTableType(String targetTableTypeName) {
        TableType targetTableType = null;
        for (TableType availableTableType : availableTableTypes) {
            if (!availableTableType.getName().equals(targetTableTypeName)) continue;
            targetTableType = availableTableType;
        }
        return targetTableType;
    }

    private void checkInvocation(OperationInvocation invocation) throws InvalidInvocationException {
        try {
            List<String> admittedValues = this.getAdmittedValues(this.cubeManager.getTable(invocation.getTargetTableId()).getTableType());
            String tableTypeName = (String)invocation.getParameterInstances().get(TABLE_TYPE_PARAMETER_ID);
            if (!admittedValues.contains(tableTypeName)) {
                throw new InvalidInvocationException(invocation, "Provided value is not admitted: " + tableTypeName);
            }
        }
        catch (InvalidInvocationException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("Invalid invocation caused by exception", (Throwable)e);
            throw new InvalidInvocationException(invocation, "Uncaught exception caused invocation check to fail", e);
        }
    }

    protected String getOperationName() {
        return "Change table type";
    }

    protected String getOperationDescription() {
        return "Modify the table type";
    }

    protected OperationDescriptor.OperationId getOperationId() {
        return OPERATION_ID;
    }
}

