package org.gcube.data.analysis.tabulardata.operation.table;

import java.util.List;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.OperationId;
import org.gcube.data.analysis.tabulardata.operation.factories.types.TableTransformationWorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.Parameter;
import org.gcube.data.analysis.tabulardata.operation.worker.Worker;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;

import com.google.common.collect.Lists;

@Singleton
public class CreateViewFactory extends TableTransformationWorkerFactory {

	private static final OperationId OPERATION_ID = new OperationId(1003);

	private static final List<Parameter> parameters = Lists.newArrayList();

	private CubeManager cubeManager;

	private DatabaseConnectionProvider connectionProvider;

	@Inject
	public CreateViewFactory(CubeManager cubeManager, DatabaseConnectionProvider connectionProvider) {
		this.cubeManager = cubeManager;
		this.connectionProvider = connectionProvider;
	}

	private void checkTargetTableEligibility(OperationInvocation invocation) throws InvalidInvocationException {
		Table table = cubeManager.getTable(invocation.getTargetTableId());
		/*if (!table.getTableType().equals(new DatasetTableType()))
			throw new InvalidInvocationException(invocation,"Table is not a dataset");*/
		if (!table.hasRelationships())
			throw new InvalidInvocationException(invocation,"Table has no relationship, a view is not needed");
	}

	public Worker createWorker(OperationInvocation invocation) throws InvalidInvocationException {
		performBaseChecks(invocation);
		checkTargetTableEligibility(invocation);
		return new CreateView(cubeManager, connectionProvider, invocation);
	}

	@Override
	protected String getOperationName() {
		return "Create dataset view";
	}

	@Override
	protected String getOperationDescription() {
		return "Create a dataset materialized view with data from linked codelists";
	}

	@Override
	protected OperationId getOperationId() {
		return OPERATION_ID;
	}

	@Override
	protected List<Parameter> getParameters() {
		return parameters; 
	}

}
