/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.validation;

import java.sql.SQLException;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.factories.ValidationColumnFactory;
import org.gcube.data.analysis.tabulardata.model.metadata.column.ColumnMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.column.DataValidationMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.column.ValidationReferencesMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.common.ImmutableLocalizedText;
import org.gcube.data.analysis.tabulardata.model.metadata.common.LocalizedText;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.time.PeriodType;
import org.gcube.data.analysis.tabulardata.operation.OperationHelper;
import org.gcube.data.analysis.tabulardata.operation.SQLHelper;
import org.gcube.data.analysis.tabulardata.operation.ValidationHelper;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.time.PeriodTypeHelper;
import org.gcube.data.analysis.tabulardata.operation.time.PeriodTypeHelperProvider;
import org.gcube.data.analysis.tabulardata.operation.validation.TimeDimensionColumnValidatorFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.ImmutableWorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.Worker;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;

public class TimeDimensionColumnValidator
extends Worker {
    private CubeManager cubeManager;
    private DatabaseConnectionProvider connectionProvider;
    private Table targetTable;
    private Column targetColumn;
    private Column validationColumn;
    private String periodTypeName;
    private PeriodTypeHelperProvider periodTypeHelperProvider;

    public TimeDimensionColumnValidator(OperationInvocation sourceInvocation, CubeManager cubeManager, DatabaseConnectionProvider connectionProvider, PeriodTypeHelperProvider periodTypeHelperProvider) {
        super(sourceInvocation);
        this.cubeManager = cubeManager;
        this.connectionProvider = connectionProvider;
        this.periodTypeHelperProvider = periodTypeHelperProvider;
    }

    protected WorkerResult execute() throws WorkerException {
        this.retrieveParameters();
        this.updateProgress(0.1f);
        this.createValidationTable();
        this.updateProgress(0.4f);
        this.fillValidationTableWithValidationData();
        this.updateProgress(0.8f);
        this.evaluateValidationResultAndUpdateTableMeta();
        return new ImmutableWorkerResult(this.targetTable);
    }

    private void evaluateValidationResultAndUpdateTableMeta() throws WorkerException {
        ValidationReferencesMetadata referencesMeta;
        boolean valid = ValidationHelper.evaluateValidationColumnValidity(this.connectionProvider, this.targetTable.getName(), this.validationColumn.getName());
        DataValidationMetadata dataValidationMetadata = this.createDataValidationMetadata(valid);
        this.targetTable = this.cubeManager.modifyTableMeta(this.targetTable.getId()).setColumnMetadata(this.validationColumn.getLocalId(), new ColumnMetadata[]{dataValidationMetadata}).create();
        if (this.targetColumn.contains(ValidationReferencesMetadata.class)) {
            referencesMeta = (ValidationReferencesMetadata)this.targetColumn.getMetadata(ValidationReferencesMetadata.class);
            referencesMeta.add(this.validationColumn.getLocalId());
        } else {
            referencesMeta = new ValidationReferencesMetadata(this.validationColumn.getLocalId());
        }
        this.targetTable = this.cubeManager.modifyTableMeta(this.targetTable.getId()).setColumnMetadata(this.targetColumn.getLocalId(), new ColumnMetadata[]{referencesMeta}).create();
    }

    private void fillValidationTableWithValidationData() throws WorkerException {
        PeriodTypeHelper helper = this.periodTypeHelperProvider.getHelper(PeriodType.fromName((String)this.periodTypeName));
        try {
            SQLHelper.executeSQLCommand(helper.getFillValidationColumnSQL(this.targetTable.getName(), this.validationColumn.getName(), this.targetColumn.getName()), this.connectionProvider);
        }
        catch (SQLException e) {
            throw new WorkerException("Unable to evaluate validation condition on DB", (Throwable)e);
        }
    }

    private void createValidationTable() {
        this.validationColumn = this.createValidationColumn(false);
        this.targetTable = this.cubeManager.addValidations(this.targetTable.getId(), new Column[]{this.validationColumn});
    }

    private Column createValidationColumn(boolean valid) {
        ImmutableLocalizedText name = new ImmutableLocalizedText(String.format("Is valid %s format?", this.periodTypeName));
        DataValidationMetadata dataValidationMetadata = this.createDataValidationMetadata(valid);
        return ValidationColumnFactory.create((LocalizedText)name, (DataValidationMetadata)dataValidationMetadata);
    }

    private DataValidationMetadata createDataValidationMetadata(boolean valid) {
        String descriptionText = String.format("Tells if %s is of valid %s format", OperationHelper.retrieveColumnLabel(this.targetColumn), this.periodTypeName);
        ImmutableLocalizedText description = new ImmutableLocalizedText(descriptionText);
        return new DataValidationMetadata((LocalizedText)description, valid);
    }

    private void retrieveParameters() {
        this.targetTable = this.cubeManager.getTable(this.getSourceInvocation().getTargetTableId());
        this.targetColumn = this.targetTable.getColumnById(this.getSourceInvocation().getTargetColumnId());
        this.periodTypeName = (String)OperationHelper.getParameter(TimeDimensionColumnValidatorFactory.PERIOD_FORMAT_PARAMETER, this.getSourceInvocation());
    }
}

