/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.validation;

import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.factories.ValidationColumnFactory;
import org.gcube.data.analysis.tabulardata.model.metadata.column.ColumnMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.column.DataValidationMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.column.ValidationReferencesMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.common.ImmutableLocalizedText;
import org.gcube.data.analysis.tabulardata.model.metadata.common.LocalizedText;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.SQLHelper;
import org.gcube.data.analysis.tabulardata.operation.ValidationHelper;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.worker.ImmutableWorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.Worker;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuplicateValuesInColumnValidator
extends Worker {
    private static final Logger log = LoggerFactory.getLogger(DuplicateValuesInColumnValidator.class);
    private CubeManager cubeManager;
    private DatabaseConnectionProvider connectionProvider;
    private Table targetTable;
    private Column targetColumn;
    private Column validationColumn;

    public DuplicateValuesInColumnValidator(OperationInvocation sourceInvocation, CubeManager cubeManager, DatabaseConnectionProvider connectionProvider) {
        super(sourceInvocation);
        this.cubeManager = cubeManager;
        this.connectionProvider = connectionProvider;
    }

    protected WorkerResult execute() throws WorkerException {
        this.retrieveParameters();
        this.updateProgress(0.3f);
        this.createNewTableWithValidationColumn();
        this.updateProgress(0.5f);
        this.fillNewTableWithData();
        this.updateProgress(0.8f);
        this.evaluateValidityAndUpdateTableMeta();
        return new ImmutableWorkerResult(this.targetTable);
    }

    private void retrieveParameters() {
        this.targetTable = this.cubeManager.getTable(this.getSourceInvocation().getTargetTableId());
        this.targetColumn = this.targetTable.getColumnById(this.getSourceInvocation().getTargetColumnId());
    }

    private void createNewTableWithValidationColumn() {
        ValidationReferencesMetadata referencesMeta;
        DataValidationMetadata dataValidationMetadata = this.createDataValidationMetadata(false);
        this.validationColumn = new ValidationColumnFactory().create((LocalizedText)new ImmutableLocalizedText("Not duplicate"), dataValidationMetadata);
        this.targetTable = this.cubeManager.addValidations(this.targetTable.getId(), new Column[]{this.validationColumn});
        if (this.targetColumn.contains(ValidationReferencesMetadata.class)) {
            referencesMeta = (ValidationReferencesMetadata)this.targetColumn.getMetadata(ValidationReferencesMetadata.class);
            referencesMeta.add(this.validationColumn.getLocalId());
        } else {
            referencesMeta = new ValidationReferencesMetadata(this.validationColumn.getLocalId());
        }
        this.targetTable = this.cubeManager.modifyTableMeta(this.targetTable.getId()).setColumnMetadata(this.targetColumn.getLocalId(), new ColumnMetadata[]{referencesMeta}).create();
    }

    private DataValidationMetadata createDataValidationMetadata(boolean valid) {
        return new DataValidationMetadata((LocalizedText)new ImmutableLocalizedText("True when the value in column " + this.targetColumn.getName() + " is not a duplicate, false otherwise"), valid);
    }

    private void fillNewTableWithData() throws WorkerException {
        try {
            SQLHelper.executeSQLBatchCommands(this.connectionProvider, this.createSetAllTrueSQL(), this.createSetFalseOnDuplicatesSQL());
        }
        catch (Exception e) {
            String msg = "Unable to perform SQL operation";
            log.error(msg, (Throwable)e);
            throw new WorkerException(msg);
        }
    }

    private String createSetAllTrueSQL() {
        return String.format("UPDATE %1$s as newtable SET %2$s = true;", this.targetTable.getName(), this.validationColumn.getName());
    }

    private String createSetFalseOnDuplicatesSQL() {
        return String.format("WITH duplicates AS (Select %1$s from %2$s group by %1$s  having count(*)>1),firsts AS (Select distinct(first_value(%2$s.id) over (partition by %1$s )) AS id  from %2$s  where %1$s  IN (Select %1$s  from duplicates))Update %2$s  SET %3$s = false WHERE id not in (SELECT id from firsts) AND %1$s in (SELECT %1$s  from duplicates)", this.targetColumn.getName(), this.targetTable.getName(), this.validationColumn.getName());
    }

    private void evaluateValidityAndUpdateTableMeta() throws WorkerException {
        boolean valid = ValidationHelper.evaluateValidationColumnValidity(this.connectionProvider, this.targetTable.getName(), this.validationColumn.getName());
        DataValidationMetadata validationMetadata = this.createDataValidationMetadata(valid);
        this.targetTable = this.cubeManager.modifyTableMeta(this.targetTable.getId()).setColumnMetadata(this.validationColumn.getLocalId(), new ColumnMetadata[]{validationMetadata}).create();
    }
}

