/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.validation;

import java.util.ArrayList;
import java.util.List;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.cube.tablemanagers.TableMetaCreator;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.column.factories.ValidationColumnFactory;
import org.gcube.data.analysis.tabulardata.model.column.type.IdColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.ValidationColumnType;
import org.gcube.data.analysis.tabulardata.model.metadata.column.ColumnMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.column.DataValidationMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.column.ValidationReferencesMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.common.ImmutableLocalizedText;
import org.gcube.data.analysis.tabulardata.model.metadata.common.LocalizedText;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.SQLHelper;
import org.gcube.data.analysis.tabulardata.operation.ValidationHelper;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.validation.DuplicateRowValidatorFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.ImmutableWorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.Worker;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuplicateRowValidator
extends Worker {
    private static final Logger log = LoggerFactory.getLogger(DuplicateRowValidator.class);
    CubeManager cubeManager;
    DatabaseConnectionProvider connectionProvider;
    Table targetTable;
    Column validationColumn;
    List<Column> toCheckColumns = null;

    public DuplicateRowValidator(OperationInvocation sourceInvocation, CubeManager cubeManager, DatabaseConnectionProvider connectionProvider) {
        super(sourceInvocation);
        this.cubeManager = cubeManager;
        this.connectionProvider = connectionProvider;
    }

    protected WorkerResult execute() throws WorkerException {
        this.retrieveTargetTable();
        this.updateProgress(0.2f);
        this.createNewTableWithValidationColumn();
        this.updateProgress(0.4f);
        this.fillNewTableWithData();
        this.updateProgress(0.8f);
        this.evaluateValidityAndUpdateTableMeta();
        return new ImmutableWorkerResult(this.targetTable);
    }

    private void evaluateValidityAndUpdateTableMeta() throws WorkerException {
        boolean valid = ValidationHelper.evaluateValidationColumnValidity(this.connectionProvider, this.targetTable.getName(), this.validationColumn.getName());
        DataValidationMetadata validationMetadata = this.createDataValidationMetadata(valid);
        this.targetTable = this.cubeManager.modifyTableMeta(this.targetTable.getId()).setColumnMetadata(this.validationColumn.getLocalId(), new ColumnMetadata[]{validationMetadata}).create();
    }

    private void fillNewTableWithData() throws WorkerException {
        try {
            SQLHelper.executeSQLBatchCommands(this.connectionProvider, this.createSetAllTrueSQL(), this.createSetDuplicateASFalse());
        }
        catch (Exception e) {
            String msg = "Unable to perform SQL operation";
            log.error(msg, (Throwable)e);
            throw new WorkerException(msg);
        }
    }

    private String createSetAllTrueSQL() {
        return String.format("UPDATE %1$s as newtable SET %2$s = true;", this.targetTable.getName(), this.validationColumn.getName());
    }

    private String createSetDuplicateASFalse() {
        String columnNamesSnippet = this.getColumnNamesSnippet(this.toCheckColumns);
        return String.format("WITH duplicates AS (Select %1$s from %2$s group by %1$s  having count(*)>1),firsts AS (Select distinct(first_value(%2$s .id) over (partition by %1$s )) AS id  from %2$s  where (%1$s)  IN (Select %1$s  from duplicates))Update %2$s  SET %3$s = false WHERE id not in (SELECT id from firsts) AND (%1$s) in (SELECT %1$s  from duplicates)", columnNamesSnippet, this.targetTable.getName(), this.validationColumn.getName());
    }

    private String getColumnNamesSnippet(List<Column> columnsToCheck) {
        StringBuilder columnNamesSnippet = new StringBuilder();
        for (Column column : columnsToCheck) {
            columnNamesSnippet.append(String.valueOf(column.getName()) + ", ");
        }
        columnNamesSnippet.delete(columnNamesSnippet.length() - 2, columnNamesSnippet.length() - 1);
        return columnNamesSnippet.toString();
    }

    private void createNewTableWithValidationColumn() {
        DataValidationMetadata dataValidationMetadata = this.createDataValidationMetadata(false);
        this.validationColumn = new ValidationColumnFactory().create((LocalizedText)new ImmutableLocalizedText("Not duplicate"), dataValidationMetadata);
        this.targetTable = this.cubeManager.addValidations(this.targetTable.getId(), new Column[]{this.validationColumn});
        TableMetaCreator creator = this.cubeManager.modifyTableMeta(this.targetTable.getId());
        for (Column col : this.toCheckColumns) {
            ValidationReferencesMetadata referencesMeta;
            if (col.contains(ValidationReferencesMetadata.class)) {
                referencesMeta = (ValidationReferencesMetadata)col.getMetadata(ValidationReferencesMetadata.class);
                referencesMeta.add(this.validationColumn.getLocalId());
            } else {
                referencesMeta = new ValidationReferencesMetadata(this.validationColumn.getLocalId());
            }
            creator.setColumnMetadata(col.getLocalId(), new ColumnMetadata[]{referencesMeta});
        }
        this.targetTable = creator.create();
    }

    private DataValidationMetadata createDataValidationMetadata(boolean valid) {
        return new DataValidationMetadata((LocalizedText)new ImmutableLocalizedText("True when the tuple is not a duplicate, false otherwise"), valid);
    }

    private void retrieveTargetTable() {
        this.targetTable = this.cubeManager.getTable(this.getSourceInvocation().getTargetTableId());
        if (this.getSourceInvocation().getParameterInstances().containsKey(DuplicateRowValidatorFactory.KEY.getIdentifier())) {
            this.toCheckColumns = new ArrayList<Column>();
            Object colParam = this.getSourceInvocation().getParameterInstances().get(DuplicateRowValidatorFactory.KEY.getIdentifier());
            if (colParam instanceof Iterable) {
                for (ColumnReference col : (Iterable)colParam) {
                    this.toCheckColumns.add(this.targetTable.getColumnById(col.getColumnId()));
                }
            } else {
                this.toCheckColumns.add(this.targetTable.getColumnById(((ColumnReference)colParam).getColumnId()));
            }
        } else {
            this.toCheckColumns = this.targetTable.getColumnsExceptTypes(new Class[]{IdColumnType.class, ValidationColumnType.class});
        }
        System.out.println(this.toCheckColumns);
    }
}

