/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.validation;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.expression.MalformedExpressionException;
import org.gcube.data.analysis.tabulardata.expression.TableReferenceReplacer;
import org.gcube.data.analysis.tabulardata.expression.evaluator.EvaluatorException;
import org.gcube.data.analysis.tabulardata.expression.evaluator.description.DescriptionExpressionEvaluatorFactory;
import org.gcube.data.analysis.tabulardata.expression.evaluator.sql.SQLExpressionEvaluatorFactory;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.column.factories.ValidationColumnFactory;
import org.gcube.data.analysis.tabulardata.model.metadata.column.ColumnMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.column.DataValidationMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.column.ValidationReferencesMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.common.ImmutableLocalizedText;
import org.gcube.data.analysis.tabulardata.model.metadata.common.LocalizedText;
import org.gcube.data.analysis.tabulardata.model.metadata.table.GlobalDataValidationReportMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.TableMetadata;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.operation.EmptyType;
import org.gcube.data.analysis.tabulardata.operation.OperationHelper;
import org.gcube.data.analysis.tabulardata.operation.SQLHelper;
import org.gcube.data.analysis.tabulardata.operation.ValidationHelper;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.validation.ValidateDataWithExpressionFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;
import org.gcube.data.analysis.tabulardata.operation.worker.types.ValidationWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidateDataWithExpression
extends ValidationWorker {
    private static final Logger log = LoggerFactory.getLogger(ValidateDataWithExpression.class);
    private CubeManager cubeManager;
    private DatabaseConnectionProvider connectionProvider;
    private Table targetTable;
    private Expression validationExpression;
    private String expressionDescription = null;
    private String validationTitle = null;
    private Column validationColumn;
    private SQLExpressionEvaluatorFactory sqlEvaluatorFactory;
    private DescriptionExpressionEvaluatorFactory descriptionEvaluatorFactory;
    private List<Column> evaluatedColumns = new ArrayList<Column>();

    public ValidateDataWithExpression(OperationInvocation invocation, CubeManager cubeManager, DatabaseConnectionProvider connectionProvider, SQLExpressionEvaluatorFactory sqlEvaluatorFactory, DescriptionExpressionEvaluatorFactory descriptionEvaluatorFactory) {
        super(invocation);
        this.cubeManager = cubeManager;
        this.connectionProvider = connectionProvider;
        this.sqlEvaluatorFactory = sqlEvaluatorFactory;
        this.descriptionEvaluatorFactory = descriptionEvaluatorFactory;
    }

    protected EmptyType execute() throws WorkerException {
        this.initiate();
        this.updateProgress(0.1f, "Creating validation structure");
        this.addValidationColumn();
        this.updateProgress(0.4f, "Filling validation column");
        this.fillValidationColumn();
        this.updateProgress(0.7f, "Finalizing validation");
        this.evaluateValidityAndUpdateTableMeta();
        return EmptyType.instance();
    }

    private void initiate() throws WorkerException {
        try {
            OperationInvocation invocation = this.getSourceInvocation();
            this.targetTable = this.cubeManager.getTable(invocation.getTargetTableId());
            this.validationExpression = (Expression)invocation.getParameterInstances().get(ValidateDataWithExpressionFactory.EXPRESSION_PARAMETER.getIdentifier());
            TableReferenceReplacer replacer = new TableReferenceReplacer(this.validationExpression);
            for (TableId tableId : replacer.getTableIds()) {
                if (!tableId.equals((Object)this.targetTable.getId())) continue;
                for (ColumnReference ref : replacer.getReferences(tableId)) {
                    Column col = this.targetTable.getColumnById(ref.getColumnId());
                    this.evaluatedColumns.add(col);
                }
            }
            this.expressionDescription = invocation.getParameterInstances().containsKey(ValidateDataWithExpressionFactory.DESCRIPTION_PARAMETER.getIdentifier()) ? (String)invocation.getParameterInstances().get(ValidateDataWithExpressionFactory.DESCRIPTION_PARAMETER.getIdentifier()) : (String)this.descriptionEvaluatorFactory.getEvaluator(this.validationExpression).evaluate();
            this.validationTitle = invocation.getParameterInstances().containsKey(ValidateDataWithExpressionFactory.VALIDATION_TITLE_PARAMETER.getIdentifier()) ? (String)invocation.getParameterInstances().get(ValidateDataWithExpressionFactory.VALIDATION_TITLE_PARAMETER.getIdentifier()) : "Expression on " + OperationHelper.getColumnLabelsSnippet(this.evaluatedColumns);
        }
        catch (Exception e) {
            throw new WorkerException("Unable to initiate, wrong parameters configuration", (Throwable)e);
        }
    }

    private void evaluateValidityAndUpdateTableMeta() throws WorkerException {
        try {
            int invalidCount = ValidationHelper.getErrorCount((DatabaseConnectionProvider)this.connectionProvider, (Table)this.targetTable, (Column)this.validationColumn, (SQLExpressionEvaluatorFactory)this.sqlEvaluatorFactory);
            GlobalDataValidationReportMetadata globalMeta = ValidationHelper.createDataValidationReport((Column)this.validationColumn);
            DataValidationMetadata validationMeta = new DataValidationMetadata((LocalizedText)new ImmutableLocalizedText(this.expressionDescription), invalidCount);
            this.targetTable = this.cubeManager.modifyTableMeta(this.targetTable.getId()).setColumnMetadata(this.validationColumn.getLocalId(), new ColumnMetadata[]{validationMeta}).setTableMetadata(new TableMetadata[]{globalMeta}).create();
        }
        catch (Exception e) {
            throw new WorkerException("Unable to evaluate global validation", (Throwable)e);
        }
    }

    private void fillValidationColumn() throws WorkerException {
        try {
            SQLHelper.executeSQLBatchCommands((DatabaseConnectionProvider)this.connectionProvider, (String[])new String[]{this.generateSetAllFalseSqlCommand(), this.generateValidationSqlCommand()});
        }
        catch (SQLException e) {
            e.getNextException().printStackTrace();
            throw new WorkerException("Error occurred while executing SQL command", (Throwable)e);
        }
    }

    private String generateSetAllFalseSqlCommand() {
        return String.format("UPDATE %s SET %s = false;", this.targetTable.getName(), this.validationColumn.getName());
    }

    private String generateValidationSqlCommand() throws WorkerException {
        try {
            this.validationExpression.validate();
            return String.format("UPDATE %s SET %s = true WHERE %s;", this.targetTable.getName(), this.validationColumn.getName(), this.sqlEvaluatorFactory.getEvaluator(this.validationExpression).evaluate());
        }
        catch (EvaluatorException e) {
            throw new WorkerException("Unable to evaluate epression", (Throwable)e);
        }
        catch (MalformedExpressionException e) {
            throw new WorkerException("Unable to evaluate epression", (Throwable)e);
        }
    }

    private void addValidationColumn() throws WorkerException {
        DataValidationMetadata validationMeta = new DataValidationMetadata((LocalizedText)new ImmutableLocalizedText(this.expressionDescription), 0);
        this.validationColumn = new ValidationColumnFactory().create((LocalizedText)new ImmutableLocalizedText(this.validationTitle), validationMeta);
        this.targetTable = this.cubeManager.addValidations(this.targetTable.getId(), new Column[]{this.validationColumn});
        log.debug("Added validation column:\n" + this.targetTable);
        ValidationReferencesMetadata meta = new ValidationReferencesMetadata(this.evaluatedColumns.toArray(new Column[this.evaluatedColumns.size()]));
        this.targetTable = this.cubeManager.modifyTableMeta(this.targetTable.getId()).setColumnMetadata(this.validationColumn.getLocalId(), new ColumnMetadata[]{meta}).create();
    }
}

