/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.column;

import com.google.common.collect.Lists;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.cube.tablemanagers.TableCreator;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.factories.TimeDimensionColumnFactory;
import org.gcube.data.analysis.tabulardata.model.column.type.IdColumnType;
import org.gcube.data.analysis.tabulardata.model.metadata.table.GenericMapMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.TableMetadata;
import org.gcube.data.analysis.tabulardata.model.relationship.ColumnRelationship;
import org.gcube.data.analysis.tabulardata.model.relationship.ImmutableColumnRelationship;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.time.PeriodType;
import org.gcube.data.analysis.tabulardata.operation.OperationHelper;
import org.gcube.data.analysis.tabulardata.operation.SQLHelper;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.LeafParameter;
import org.gcube.data.analysis.tabulardata.operation.time.PeriodTypeHelper;
import org.gcube.data.analysis.tabulardata.operation.time.PeriodTypeHelperProvider;
import org.gcube.data.analysis.tabulardata.operation.validation.TimeDimensionColumnValidatorFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;
import org.gcube.data.analysis.tabulardata.operation.worker.results.ImmutableWorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.results.WorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.types.DataWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeToTimeDimensionColumn
extends DataWorker {
    private static final Logger log = LoggerFactory.getLogger(ChangeToTimeDimensionColumn.class);
    private CubeManager cubeManager;
    private DatabaseConnectionProvider connectionProvider;
    private Table targetTable;
    private Column targetColumn;
    private PeriodType periodType;
    private Table newTable;
    private Table timeCodelist;
    private PeriodTypeHelper helper;
    private PeriodTypeHelperProvider periodTypeHelperProvider;
    private Column timeDimensionColumn;

    public ChangeToTimeDimensionColumn(OperationInvocation sourceInvocation, CubeManager cubeManager, DatabaseConnectionProvider connectionProvider, PeriodTypeHelperProvider periodTypeHelperProvider) {
        super(sourceInvocation);
        this.cubeManager = cubeManager;
        this.connectionProvider = connectionProvider;
        this.periodTypeHelperProvider = periodTypeHelperProvider;
    }

    protected WorkerResult execute() throws WorkerException {
        this.retrieveParameters();
        this.helper = this.periodTypeHelperProvider.getHelper(this.periodType);
        this.updateProgress(0.1f, "creating time codelist");
        this.createTimeCodelist();
        this.updateProgress(0.3f, "creating new table");
        this.createNewTable();
        this.updateProgress(0.6f, "linking table to the time codelist");
        this.linkNewTableToTimeCodelist();
        this.cubeManager.removeColumn(this.newTable.getId(), this.targetColumn.getLocalId());
        this.updateProgress(0.8f, "preparating table for future rollback");
        return new ImmutableWorkerResult(this.newTable, this.createDiff(this.targetTable, this.targetColumn), (List)Lists.newArrayList((Object[])new Table[]{this.timeCodelist}));
    }

    private void linkNewTableToTimeCodelist() throws WorkerException {
        String sql = this.helper.getUpdateDimensionColumnSQL(this.targetColumn.getName(), this.newTable.getName(), this.timeDimensionColumn.getName(), this.timeCodelist.getName());
        try {
            SQLHelper.executeSQLCommand((String)sql, (DatabaseConnectionProvider)this.connectionProvider);
        }
        catch (SQLException e) {
            throw new WorkerException("Unable to link target table tuples to the newly created time codelist", (Throwable)e);
        }
    }

    private void createNewTable() {
        this.timeDimensionColumn = new TimeDimensionColumnFactory().create(this.periodType);
        Column refColumn = this.timeCodelist.getColumnByName(this.helper.getColumnName());
        this.timeDimensionColumn.setRelationship((ColumnRelationship)new ImmutableColumnRelationship(this.timeCodelist.getId(), refColumn.getLocalId()));
        TableCreator tableCreator = this.cubeManager.createTable(this.targetTable.getTableType());
        tableCreator.like(this.targetTable, true);
        tableCreator.addColumn(this.timeDimensionColumn);
        this.newTable = tableCreator.create();
    }

    private void createTimeCodelist() throws WorkerException {
        PeriodTypeHelper helper = this.periodTypeHelperProvider.getHelper(this.periodType);
        this.timeCodelist = helper.createTimeCodelist();
        String fillTimeCodelistSQL = helper.getFillTimeCodelistSQL(this.targetTable.getName(), this.targetColumn.getName(), this.timeCodelist.getName());
        try {
            SQLHelper.executeSQLCommand((String)fillTimeCodelistSQL, (DatabaseConnectionProvider)this.connectionProvider);
        }
        catch (SQLException e) {
            String msg = "An error occurred while filling the time dimension table, data is probably not suited for the operation";
            log.error(msg);
            throw new WorkerException(msg);
        }
    }

    private void retrieveParameters() {
        this.targetTable = this.cubeManager.getTable(this.getSourceInvocation().getTargetTableId());
        this.targetColumn = this.targetTable.getColumnById(this.getSourceInvocation().getTargetColumnId());
        String periodTypeName = (String)OperationHelper.getParameter((LeafParameter)TimeDimensionColumnValidatorFactory.PERIOD_FORMAT_PARAMETER, (OperationInvocation)this.getSourceInvocation());
        this.periodType = PeriodType.fromName((String)periodTypeName);
    }

    private Table createDiff(Table targetTable, Column targetColumn) {
        ArrayList<Column> columnsToRemove = new ArrayList<Column>(targetTable.getColumns().size() - 1);
        for (Column col : targetTable.getColumnsExceptTypes(new Class[]{IdColumnType.class})) {
            if (col.equals((Object)targetColumn)) continue;
            columnsToRemove.add(col);
        }
        TableCreator tableCreator = this.cubeManager.createTable(targetTable.getTableType()).like(targetTable, true, columnsToRemove);
        Table toReturn = tableCreator.create();
        GenericMapMetadata gmm = new GenericMapMetadata(Collections.singletonMap("referenceColumn", this.timeDimensionColumn.getLocalId().getValue()));
        return this.cubeManager.modifyTableMeta(toReturn.getId()).setTableMetadata(new TableMetadata[]{gmm}).create();
    }
}

