/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.time;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.time.PeriodType;
import org.gcube.data.analysis.tabulardata.operation.time.PeriodTypeHelper;

@Singleton
public class DayHelper
implements PeriodTypeHelper {
    private CubeManager cubeManager;

    @Inject
    public DayHelper(CubeManager cubeManager) {
        this.cubeManager = cubeManager;
    }

    @Override
    public String getFillValidationColumnSQL(String validationTableName, String validationColumnName, String targetColumnName) {
        return String.format("UPDATE %1$s SET %2$s = true WHERE %3$s in (SELECT %4$s_code From %4$s) ", validationTableName, validationColumnName, targetColumnName, this.getManagedPeriodType().getName());
    }

    @Override
    public Table createTimeCodelist() {
        return this.cubeManager.createTimeCodelist(PeriodType.DAY);
    }

    @Override
    public PeriodType getManagedPeriodType() {
        return PeriodType.DAY;
    }

    @Override
    public String getUpdateDimensionColumnSQL(String targetColumnName, String newTableName, String timeDimensionColumnName, String timeTableName) {
        return String.format("UPDATE %1$s AS new_table SET %2$s = refCol.id FROM (SELECT id,  day_code as val FROM %3$s) as refCol WHERE refCol.val=normalize_day(to_iso_day(new_table.%4$s)) ;", newTableName, timeDimensionColumnName, timeTableName, targetColumnName);
    }
}

