/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.column;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.cube.tablemanagers.TableCreator;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.IdColumnType;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.datatype.TextType;
import org.gcube.data.analysis.tabulardata.model.metadata.column.ColumnMetadata;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.SQLHelper;
import org.gcube.data.analysis.tabulardata.operation.column.ChangeColumnTypeTransformationFactory;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;
import org.gcube.data.analysis.tabulardata.operation.worker.results.ImmutableWorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.results.WorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.types.DataWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleTextTypedColumnTypeTransformation
extends DataWorker {
    private static final Logger log = LoggerFactory.getLogger(SimpleTextTypedColumnTypeTransformation.class);
    private ColumnType managedColumnType;
    private Table targetTable;
    private Column targetColumn;
    private CubeManager cubeManager;
    private DatabaseConnectionProvider databaseConnectionProvider;
    Table newTable = null;

    public SimpleTextTypedColumnTypeTransformation(OperationInvocation invocation, CubeManager cubeManager, DatabaseConnectionProvider databaseConnectionProvider, ColumnType managedColumnType) {
        super(invocation);
        this.cubeManager = cubeManager;
        this.databaseConnectionProvider = databaseConnectionProvider;
        this.targetTable = cubeManager.getTable(invocation.getTargetTableId());
        this.targetColumn = this.targetTable.getColumnById(invocation.getTargetColumnId());
        this.managedColumnType = managedColumnType;
    }

    protected WorkerResult execute() throws WorkerException {
        this.updateProgress(0.1f, "creating new table");
        this.createNewTable();
        this.updateProgress(0.5f, "filling new table with data");
        this.fillNewTableWithData();
        this.updateProgress(0.8f, "preparing table for future rollback");
        return new ImmutableWorkerResult(this.newTable, this.createDiff(this.targetTable, this.targetColumn));
    }

    private void fillNewTableWithData() throws WorkerException {
        String sqlCommand = this.generateSQLFillCommand(this.targetTable, this.newTable);
        try {
            SQLHelper.executeSQLCommand((String)sqlCommand, (DatabaseConnectionProvider)this.databaseConnectionProvider);
        }
        catch (Exception e) {
            throw new WorkerException("Unable to fill new table with data", (Throwable)e);
        }
    }

    private void createNewTable() {
        TableCreator tableCreator = this.cubeManager.createTable(this.targetTable.getTableType());
        log.debug("Column to remove: " + this.targetColumn);
        for (Column oldColumn : this.targetTable.getColumnsExceptTypes(new Class[]{IdColumnType.class})) {
            Column newColumn = null;
            if (oldColumn.equals((Object)this.targetColumn)) {
                newColumn = new Column(this.targetColumn.getLocalId(), (DataType)new TextType(), this.managedColumnType);
                Collection toSetMetadata = this.targetColumn.getAllMetadata();
                if (this.getSourceInvocation().getParameterInstances().containsKey(ChangeColumnTypeTransformationFactory.ADDITIONAL_META_PARAMETER.getIdentifier())) {
                    Object additional = this.getSourceInvocation().getParameterInstances().get(ChangeColumnTypeTransformationFactory.ADDITIONAL_META_PARAMETER.getIdentifier());
                    if (additional instanceof Collection) {
                        toSetMetadata.addAll((Collection)additional);
                    } else {
                        toSetMetadata.add((ColumnMetadata)additional);
                    }
                }
                newColumn.setAllMetadata(toSetMetadata);
                newColumn.setName(this.targetColumn.getName());
            } else {
                newColumn = oldColumn;
            }
            tableCreator.addColumn(newColumn);
        }
        this.newTable = tableCreator.create();
        log.trace("Empty table created:\n" + this.newTable);
    }

    private String generateSQLFillCommand(Table sourceTable, Table newTable) {
        StringBuilder sqlBuilder = new StringBuilder();
        List columnsToCopy = newTable.getColumns();
        String columnNamesSnippet = SQLHelper.generateColumnNameSnippet((List)columnsToCopy);
        sqlBuilder.append(String.format("INSERT INTO %s (%s) ", newTable.getName(), columnNamesSnippet));
        sqlBuilder.append(String.format("SELECT %s FROM %s;", columnNamesSnippet, sourceTable.getName()));
        return sqlBuilder.toString();
    }

    private Table createDiff(Table targetTable, Column targetColumn) {
        ArrayList<Column> columnsToRemove = new ArrayList<Column>(targetTable.getColumns().size() - 1);
        for (Column col : targetTable.getColumnsExceptTypes(new Class[]{IdColumnType.class})) {
            if (col.equals((Object)targetColumn)) continue;
            columnsToRemove.add(col);
        }
        TableCreator tableCreator = this.cubeManager.createTable(targetTable.getTableType()).like(targetTable, true, columnsToRemove);
        return tableCreator.create();
    }
}

