/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.time;

import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.expression.evaluator.sql.SQLExpressionEvaluatorFactory;
import org.gcube.data.analysis.tabulardata.model.ValueFormat;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.time.PeriodType;

public abstract class PeriodTypeHelper {
    private CubeManager cubeManager;

    public abstract PeriodType getManagedPeriodType();

    public PeriodTypeHelper(CubeManager cubeManager) {
        this.cubeManager = cubeManager;
    }

    public final String getFillValidationColumnSQL(String validationTableName, String validationColumnName, String targetColumnName, ValueFormat timeFormat, SQLExpressionEvaluatorFactory sqlEvaluatorFactory) {
        String columnToVerify = targetColumnName;
        if (timeFormat.getConverter() != null) {
            columnToVerify = String.format("regexp_replace(%s, '%s', '%s')", targetColumnName, sqlEvaluatorFactory.getEvaluator(timeFormat.getConverter().getExpression()).evaluate());
        }
        return String.format("UPDATE %1$s SET %2$s = true WHERE  %3$s in (SELECT %4$s_code From %4$s) ", validationTableName, validationColumnName, columnToVerify, this.getManagedPeriodType().getName());
    }

    public Table createTimeCodelist() {
        return this.cubeManager.getTimeTable(this.getManagedPeriodType());
    }

    public String getUpdateDimensionColumnSQL(String targetColumnName, String newTableName, String timeDimensionColumnName, String timeTableName, ValueFormat timeFormat, SQLExpressionEvaluatorFactory sqlEvaluatorFactory) {
        String columnToVerify = targetColumnName;
        if (timeFormat.getConverter() != null) {
            columnToVerify = String.format("regexp_replace(%s, '%s', '%s')", targetColumnName, sqlEvaluatorFactory.getEvaluator(timeFormat.getConverter().getExpression()).evaluate());
        }
        return String.format("UPDATE %1$s AS new_table SET %2$s = refCol.id FROM (SELECT id,  %5$s_code as val FROM %3$s) as refCol WHERE refCol.val= %4$s;", newTableName, timeDimensionColumnName, timeTableName, columnToVerify, this.getManagedPeriodType().getName().toLowerCase());
    }
}

