/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.validation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.expression.evaluator.sql.SQLExpressionEvaluatorFactory;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDTypeValue;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.type.CodelistTableType;
import org.gcube.data.analysis.tabulardata.operation.OperationHelper;
import org.gcube.data.analysis.tabulardata.operation.OperationId;
import org.gcube.data.analysis.tabulardata.operation.factories.types.ColumnValidatorFactory;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.Cardinality;
import org.gcube.data.analysis.tabulardata.operation.parameters.Parameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.MapParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.TargetColumnParameter;
import org.gcube.data.analysis.tabulardata.operation.validation.ValidateAmbiguousReference;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;
import org.gcube.data.analysis.tabulardata.operation.worker.types.ValidationWorker;

public class ValidateAmbiguousReferenceFactory
extends ColumnValidatorFactory {
    private static List<Parameter> parameters;
    private static final OperationId OPERATION_ID;
    private CubeManager cubeManager;
    private DatabaseConnectionProvider connectionProvider;
    private SQLExpressionEvaluatorFactory sqlEvaluatorFactory;
    public static TargetColumnParameter TARGET_COLUMN_PARAMETER;
    public static MapParameter MAPPING_PARAMETER;

    @Inject
    public ValidateAmbiguousReferenceFactory(CubeManager cubeManager, DatabaseConnectionProvider connectionProvider, SQLExpressionEvaluatorFactory sqlEvaluatorFactory) {
        this.cubeManager = cubeManager;
        this.connectionProvider = connectionProvider;
        this.sqlEvaluatorFactory = sqlEvaluatorFactory;
    }

    public ValidationWorker createWorker(OperationInvocation invocation) throws InvalidInvocationException {
        this.performBaseChecks(invocation, this.cubeManager);
        return new ValidateAmbiguousReference(invocation, this.cubeManager, this.connectionProvider, this.sqlEvaluatorFactory);
    }

    public String describeInvocation(OperationInvocation toDescribeInvocation) throws InvalidInvocationException {
        this.performBaseChecks(toDescribeInvocation, this.cubeManager);
        Table table = this.cubeManager.getTable(toDescribeInvocation.getTargetTableId());
        Column column = table.getColumnById(toDescribeInvocation.getTargetColumnId());
        ColumnReference columnReference = (ColumnReference)toDescribeInvocation.getParameterInstances().get(TARGET_COLUMN_PARAMETER.getIdentifier());
        Table referredTable = this.cubeManager.getTable(columnReference.getTableId());
        Column referredColumn = referredTable.getColumnById(columnReference.getColumnId());
        String mappingDescription = "";
        if (toDescribeInvocation.getParameterInstances().get(MAPPING_PARAMETER.getIdentifier()) != null) {
            mappingDescription = "passing mapping to resolve conflicts";
        }
        return String.format("Validate column %s.%s for ambiguos referred values in column %s.%s  %s", OperationHelper.retrieveTableLabel((Table)table), OperationHelper.retrieveColumnLabel((Column)column), OperationHelper.retrieveTableLabel((Table)referredTable), OperationHelper.retrieveColumnLabel((Column)referredColumn), mappingDescription);
    }

    protected String getOperationName() {
        return "Ambiguous external reference check";
    }

    protected String getOperationDescription() {
        return "Check for ambiguous values in external references";
    }

    protected List<Parameter> getParameters() {
        return parameters;
    }

    protected OperationId getOperationId() {
        return OPERATION_ID;
    }

    static {
        OPERATION_ID = new OperationId(5007L);
        MAPPING_PARAMETER = new MapParameter("mapping", "Mapping", "Maps dataset entry to external entry", Cardinality.OPTIONAL, TDTypeValue.class, Long.class);
        ArrayList<CodelistTableType> allowedTableTypes = new ArrayList<CodelistTableType>();
        allowedTableTypes.add(new CodelistTableType());
        TARGET_COLUMN_PARAMETER = new TargetColumnParameter("refColumn", "Codelist referenced column", "A codelist column containing values that are contained in the target column", Cardinality.ONE, allowedTableTypes);
        parameters = Arrays.asList(TARGET_COLUMN_PARAMETER, MAPPING_PARAMETER);
    }
}

