/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.sdmx.datastructuredefinition;

import com.google.common.collect.Lists;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.metadata.NoSuchMetadataException;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.column.type.AttributeColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.DimensionColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.MeasureColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.TimeDimensionColumnType;
import org.gcube.data.analysis.tabulardata.model.metadata.common.LocalizedText;
import org.gcube.data.analysis.tabulardata.model.metadata.common.NamesMetadata;
import org.gcube.data.analysis.tabulardata.model.relationship.ColumnRelationship;
import org.gcube.data.analysis.tabulardata.model.resources.ResourceType;
import org.gcube.data.analysis.tabulardata.model.resources.SDMXResource;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.sdmx.WorkerUtils;
import org.gcube.data.analysis.tabulardata.operation.sdmx.codelist.SDMXCodelistGenerator;
import org.gcube.data.analysis.tabulardata.operation.sdmx.conceptscheme.SDMXConceptSchemeGenerator;
import org.gcube.data.analysis.tabulardata.operation.sdmx.datastructuredefinition.DataStructureDefinitionWorkerUtils;
import org.gcube.data.analysis.tabulardata.operation.sdmx.datastructuredefinition.ds.DataSourceConfigurationBean;
import org.gcube.data.analysis.tabulardata.operation.sdmx.excel.impl.ExcelGeneratorFromTable;
import org.gcube.data.analysis.tabulardata.operation.sdmx.security.Credentials;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;
import org.gcube.data.analysis.tabulardata.operation.worker.results.ResourcesResult;
import org.gcube.data.analysis.tabulardata.operation.worker.results.resources.ImmutableSDMXResource;
import org.gcube.data.analysis.tabulardata.operation.worker.results.resources.ResourceDescriptorResult;
import org.gcube.data.analysis.tabulardata.operation.worker.types.ResourceCreatorWorker;
import org.gcube.datapublishing.sdmx.api.registry.SDMXRegistryClient;
import org.gcube.datapublishing.sdmx.impl.exceptions.SDMXRegistryClientException;
import org.gcube.datapublishing.sdmx.impl.exceptions.SDMXVersionException;
import org.sdmxsource.sdmx.api.constants.ATTRIBUTE_ATTACHMENT_LEVEL;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.model.beans.base.IdentifiableBean;
import org.sdmxsource.sdmx.api.model.beans.codelist.CodelistBean;
import org.sdmxsource.sdmx.api.model.beans.reference.StructureReferenceBean;
import org.sdmxsource.sdmx.api.model.mutable.base.ItemMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.base.RepresentationMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.base.TextTypeWrapperMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.codelist.CodelistMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.conceptscheme.ConceptMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.conceptscheme.ConceptSchemeMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.datastructure.AttributeMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.datastructure.DataStructureMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.datastructure.DataflowMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.datastructure.DimensionMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.datastructure.PrimaryMeasureMutableBean;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.base.RepresentationMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.base.TextTypeWrapperMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.datastructure.AttributeMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.datastructure.DataStructureMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.datastructure.DimensionMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.datastructure.PrimaryMeasureMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.metadatastructure.DataflowMutableBeanImpl;
import org.sdmxsource.sdmx.util.beans.reference.StructureReferenceBeanImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SDMXDataStructureDefinitionExporter
extends ResourceCreatorWorker {
    private Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private Table table;
    private OperationInvocation invocation;
    private Column primaryMeasure;
    private String registryUrl;
    private String targetAgency;
    private String targetId;
    private String targetVersion;
    private CubeManager cubeManager;
    private List<LocalizedText> tableNamesMetadata;
    private final String ATTRIBUTE_ASSIGNMENT_STATUS_MANDATORY = "Mandatory";
    private static String errorMessage = "Unable to complete export procedure";
    private DatabaseConnectionProvider connectionProvider;
    private SDMXConceptSchemeGenerator conceptSchemeGenerator;
    private String username;
    private String password;
    private boolean excel;

    public SDMXDataStructureDefinitionExporter(Table table, DatabaseConnectionProvider connectionProvider, OperationInvocation invocation, CubeManager cubeManager) {
        super(invocation);
        this.table = table;
        this.invocation = invocation;
        this.connectionProvider = connectionProvider;
        this.cubeManager = cubeManager;
        this.username = null;
        this.password = null;
    }

    protected ResourcesResult execute() throws WorkerException {
        try {
            DataSourceConfigurationBean datasourceConfigurationBean = new DataSourceConfigurationBean();
            datasourceConfigurationBean.setTable_id(this.table.getName());
            this.init(datasourceConfigurationBean);
            this.loadMetadata();
            this.updateProgress(0.1f, "Creating beans");
            DataStructureMutableBean dataStructure = this.createDataStructureBean(datasourceConfigurationBean);
            ConceptSchemeMutableBean conceptScheme = this.conceptSchemeGenerator.createConceptSchemeBean();
            DataflowMutableBean dataFlow = this.createDataFlowBean(dataStructure);
            this.updateProgress(0.2f, "Populating data structure");
            HashSet<CodelistBean> codelists = new HashSet<CodelistBean>();
            this.populateDataStructure(dataStructure, conceptScheme, datasourceConfigurationBean, codelists);
            this.updateProgress(0.6f, "Publishing");
            this.publishData(dataStructure, conceptScheme, dataFlow, codelists);
            if (this.excel) {
                this.updateProgress(0.8f, "Generating excel");
                this.generateExcel();
            }
            this.updateProgress(0.9f, "Finalizing");
            return new ResourcesResult((ResourceDescriptorResult)new ImmutableSDMXResource(new SDMXResource(new URL(this.registryUrl), this.targetId, this.targetVersion, this.targetAgency, SDMXResource.TYPE.CODE_LIST), "Codelist SDMX export", String.format("%s/%s/%s/%s/", this.registryUrl, this.targetAgency, this.targetId, this.targetVersion), ResourceType.SDMX));
        }
        catch (RuntimeException e) {
            this.log.error(errorMessage, (Throwable)e);
            throw new WorkerException(errorMessage, (Throwable)e);
        }
        catch (MalformedURLException e) {
            throw new WorkerException(String.format("exported url %s not valid", this.registryUrl), (Throwable)e);
        }
    }

    private void init(DataSourceConfigurationBean datasourceConfigurationBean) {
        this.registryUrl = (String)this.invocation.getParameterInstances().get("registryBaseUrl");
        this.targetAgency = (String)this.invocation.getParameterInstances().get("agency");
        this.targetId = (String)this.invocation.getParameterInstances().get("id");
        this.targetVersion = (String)this.invocation.getParameterInstances().get("version");
        Credentials credentials = WorkerUtils.retrieveCredentials(this.registryUrl);
        this.username = credentials.getUsername();
        this.password = credentials.getPassword();
        String observationValue = (String)this.invocation.getParameterInstances().get("obsValueColumn");
        this.primaryMeasure = this.table.getColumnById(new ColumnLocalId(observationValue));
        datasourceConfigurationBean.setObservationValue(observationValue);
        Boolean excelObject = (Boolean)this.invocation.getParameterInstances().get("excel");
        this.excel = excelObject != null && excelObject != false;
        this.conceptSchemeGenerator = new SDMXConceptSchemeGenerator(this.table, this.targetId, this.targetAgency, this.targetVersion);
    }

    private void publishData(DataStructureMutableBean dsd, ConceptSchemeMutableBean concepts, DataflowMutableBean dataFlow, Set<CodelistBean> associatedCodelists) throws WorkerException {
        String url = (String)this.invocation.getParameterInstances().get("registryBaseUrl");
        SDMXRegistryClient registryClient = DataStructureDefinitionWorkerUtils.initSDMXClient(url, this.username, this.password);
        String currentType = null;
        try {
            this.log.debug("Publishing associated codelists...");
            currentType = "codelists";
            for (CodelistBean codelist : associatedCodelists) {
                this.log.debug("Publishing codelist " + codelist.getId());
                registryClient.publish(codelist);
                this.log.debug("Codelist published");
            }
            this.log.debug("Codelists published");
            currentType = "concepts";
            this.log.debug("Publishing concepts...");
            registryClient.publish(concepts.getImmutableInstance());
            this.log.debug("Concepts published");
            currentType = "data structure definitions";
            this.log.debug("Publishing dsd...");
            registryClient.publish(dsd.getImmutableInstance());
            this.log.debug("DSD published");
            currentType = "data flow";
            this.log.debug("Publishing data flow...");
            registryClient.publish(dataFlow.getImmutableInstance());
            this.log.debug("Data flow published");
        }
        catch (SDMXVersionException e) {
            this.log.error("Error in the pubblication", (Throwable)e);
            throw new WorkerException(e.getMessage(), (Throwable)e);
        }
        catch (SDMXRegistryClientException e) {
            this.log.error("Error in the SDMX client", (Throwable)e);
            throw new WorkerException("Unable to publish dsd on registry: error in the" + currentType, (Throwable)e);
        }
    }

    private void generateExcel() {
        this.log.debug("Generating excel");
        ExcelGeneratorFromTable generator = new ExcelGeneratorFromTable(this.table);
        generator.generateExcel(String.valueOf(this.targetId) + "_" + this.targetVersion, "sdmx");
        this.log.debug("Operation completed");
    }

    private void populateDataStructure(DataStructureMutableBean dataStructure, ConceptSchemeMutableBean conceptScheme, DataSourceConfigurationBean dataSourceConfigurationBean, Set<CodelistBean> codelists) throws WorkerException {
        this.log.debug("Loading column data");
        List measureColumns = this.table.getColumnsByType(new Class[]{MeasureColumnType.class});
        List dimensionColumns = this.table.getColumnsByType(new Class[]{DimensionColumnType.class});
        List attributeColumns = this.table.getColumnsByType(new Class[]{AttributeColumnType.class});
        Column timeDimensionColumn = (Column)this.table.getColumnsByType(new Class[]{TimeDimensionColumnType.class}).get(0);
        dataSourceConfigurationBean.setObservationTime(timeDimensionColumn.getLocalId().getValue());
        this.log.debug("Columns loaded");
        boolean found = false;
        Iterator measureColumnsIterator = measureColumns.iterator();
        this.log.debug("Looking for primary measure column");
        while (measureColumnsIterator.hasNext() && !found) {
            Column column = (Column)measureColumnsIterator.next();
            if (!column.getLocalId().getValue().equals(this.primaryMeasure.getLocalId().getValue())) continue;
            measureColumns.remove(column);
            found = true;
        }
        ConceptMutableBean primaryMeasureConcept = this.conceptSchemeGenerator.createConceptBean(this.primaryMeasure);
        conceptScheme.addItem((ItemMutableBean)primaryMeasureConcept);
        StructureReferenceBeanImpl conceptReferenceBean = new StructureReferenceBeanImpl(primaryMeasureConcept.getParentAgency(), conceptScheme.getId(), this.targetVersion, SDMX_STRUCTURE_TYPE.CONCEPT, new String[]{primaryMeasureConcept.getId()});
        PrimaryMeasureMutableBeanImpl primaryMeasureBean = new PrimaryMeasureMutableBeanImpl();
        primaryMeasureBean.setConceptRef((StructureReferenceBean)conceptReferenceBean);
        primaryMeasureBean.setId("OBS_VALUE");
        dataStructure.setPrimaryMeasure((PrimaryMeasureMutableBean)primaryMeasureBean);
        this.addMeasureDimensions(dataStructure, measureColumns, conceptScheme, dataSourceConfigurationBean);
        this.addGenericDimensions(dataStructure, dimensionColumns, conceptScheme, dataSourceConfigurationBean, codelists);
        DimensionMutableBeanImpl timeDimensionBean = new DimensionMutableBeanImpl();
        timeDimensionBean.setId("TIME_PERIOD");
        ConceptMutableBean timeDimensionConcept = this.conceptSchemeGenerator.createConceptBean(timeDimensionColumn);
        conceptScheme.addItem((ItemMutableBean)timeDimensionConcept);
        timeDimensionBean.setConceptRef(this.getConceptReference(conceptScheme, timeDimensionConcept));
        timeDimensionBean.setTimeDimension(true);
        dataStructure.addDimension((DimensionMutableBean)timeDimensionBean);
        this.addAttributes(dataStructure, attributeColumns, conceptScheme, dataSourceConfigurationBean, codelists);
    }

    private void addGenericDimensions(DataStructureMutableBean dsd, List<Column> dimensionColumns, ConceptSchemeMutableBean concepts, DataSourceConfigurationBean dataSourceConfigurationBean, Set<CodelistBean> codelists) {
        this.log.debug("Adding dimension list bean");
        for (Column column : dimensionColumns) {
            ConceptMutableBean columnConcept = this.conceptSchemeGenerator.createConceptBean(column);
            concepts.addItem((ItemMutableBean)columnConcept);
            RepresentationMutableBean codedRepresentation = this.createCodeListRepresentation(column, codelists);
            if (codedRepresentation != null) {
                this.log.debug("Found a code list representation");
                columnConcept.setCoreRepresentation(codedRepresentation);
            }
            StructureReferenceBean conceptsReference = this.getConceptReference(concepts, columnConcept);
            DimensionMutableBeanImpl dimension = new DimensionMutableBeanImpl();
            dimension.setId(String.valueOf(column.getName()) + "_DSD");
            dimension.setConceptRef(conceptsReference);
            dsd.addDimension((DimensionMutableBean)dimension);
            dataSourceConfigurationBean.addDimension(columnConcept.getId(), column.getLocalId().getValue());
        }
    }

    private void addAttributes(DataStructureMutableBean dataStructure, List<Column> attributeColumns, ConceptSchemeMutableBean concepts, DataSourceConfigurationBean dataSourceConfigurationBean, Set<CodelistBean> codelists) {
        this.log.debug("Adding attribute list bean");
        for (Column column : attributeColumns) {
            ConceptMutableBean columnConcept = this.conceptSchemeGenerator.createConceptBean(column);
            concepts.addItem((ItemMutableBean)columnConcept);
            AttributeMutableBeanImpl attributeBean = new AttributeMutableBeanImpl();
            attributeBean.setAttachmentLevel(ATTRIBUTE_ATTACHMENT_LEVEL.OBSERVATION);
            attributeBean.setAssignmentStatus("Mandatory");
            RepresentationMutableBean codedRepresentation = this.createCodeListRepresentation(column, codelists);
            if (codedRepresentation != null) {
                this.log.debug("Found a code list representation");
                columnConcept.setCoreRepresentation(codedRepresentation);
            }
            attributeBean.setConceptRef(this.getConceptReference(concepts, columnConcept));
            dataStructure.addAttribute((AttributeMutableBean)attributeBean);
            dataSourceConfigurationBean.addAttributes(columnConcept.getId(), column.getLocalId().getValue());
        }
    }

    private void addMeasureDimensions(DataStructureMutableBean dsd, List<Column> measureColumns, ConceptSchemeMutableBean concepts, DataSourceConfigurationBean dataSourceConfigurationBean) {
        this.log.debug("Adding measure dimension list bean");
        for (Column column : measureColumns) {
            ConceptMutableBean columnConcept = this.conceptSchemeGenerator.createConceptBean(column);
            concepts.addItem((ItemMutableBean)columnConcept);
            DimensionMutableBeanImpl dimensionBean = new DimensionMutableBeanImpl();
            dimensionBean.setMeasureDimension(true);
            dimensionBean.setConceptRef(this.getConceptReference(concepts, columnConcept));
            dsd.addDimension((DimensionMutableBean)dimensionBean);
            dataSourceConfigurationBean.addDimension(columnConcept.getId(), column.getLocalId().getValue());
        }
    }

    private StructureReferenceBean getConceptReference(ConceptSchemeMutableBean conceptScheme, ConceptMutableBean concept) {
        this.log.debug("Creating reference for concept " + concept.getId());
        return new StructureReferenceBeanImpl(concept.getParentAgency(), conceptScheme.getId(), this.targetVersion, SDMX_STRUCTURE_TYPE.CONCEPT, new String[]{concept.getId()});
    }

    private RepresentationMutableBean createCodeListRepresentation(Column column, Set<CodelistBean> codelists) {
        this.log.debug("Creating codelist bean");
        RepresentationMutableBeanImpl response = null;
        Table codelist = this.getAssociatedCodelist(column);
        if (codelist != null) {
            this.log.debug("Table found " + codelist.getName());
            SDMXCodelistGenerator codeListGenerator = new SDMXCodelistGenerator(codelist, this.connectionProvider, this.targetAgency, String.valueOf(codelist.getName()) + "_CL", this.targetVersion);
            CodelistMutableBean codeListBean = codeListGenerator.createBaseCodelistBean();
            try {
                codeListGenerator.populateCodelistWithCodes(codeListBean);
                CodelistBean immutableCodelist = codeListBean.getImmutableInstance();
                codelists.add(immutableCodelist);
                response = new RepresentationMutableBeanImpl();
                response.setRepresentation((StructureReferenceBean)new StructureReferenceBeanImpl((IdentifiableBean)immutableCodelist));
            }
            catch (Exception e) {
                this.log.warn("Codelist not loaded", (Throwable)e);
            }
        }
        return response;
    }

    private DataStructureMutableBean createDataStructureBean(DataSourceConfigurationBean datasourceConfigurationBean) {
        DataStructureMutableBeanImpl dataStructure = new DataStructureMutableBeanImpl();
        dataStructure.setAgencyId(this.targetAgency);
        dataStructure.setVersion(this.targetVersion);
        String dsdId = String.valueOf(this.targetId) + "_DSD";
        dataStructure.setId(dsdId);
        dataStructure.setNames(this.getNamesMetadata(this.tableNamesMetadata, String.valueOf(this.targetId) + " Data Structure Definition", "en"));
        datasourceConfigurationBean.setDsdId(dsdId);
        return dataStructure;
    }

    private DataflowMutableBean createDataFlowBean(DataStructureMutableBean dataStructure) {
        DataflowMutableBeanImpl dataFlow = new DataflowMutableBeanImpl();
        this.log.debug("Populating data flow bean");
        dataFlow.setAgencyId(this.targetAgency);
        dataFlow.setDataStructureRef((StructureReferenceBean)new StructureReferenceBeanImpl(dataStructure.getAgencyId(), dataStructure.getId(), this.targetVersion, SDMX_STRUCTURE_TYPE.DSD, new String[0]));
        dataFlow.setId(String.valueOf(this.targetId) + "_dataFlow");
        dataFlow.setVersion(this.targetVersion);
        dataFlow.setNames(this.getNamesMetadata(this.tableNamesMetadata, String.valueOf(this.targetId) + " Data Flow", "en"));
        return dataFlow;
    }

    private void loadMetadata() {
        try {
            this.tableNamesMetadata = ((NamesMetadata)this.table.getMetadata(NamesMetadata.class)).getTexts();
        }
        catch (NoSuchMetadataException e) {
            this.tableNamesMetadata = Lists.newArrayList();
        }
    }

    private List<TextTypeWrapperMutableBean> getNamesMetadata(List<LocalizedText> metadataValues, String defaultValue, String defaultLocale) {
        ArrayList response = Lists.newArrayList();
        if (metadataValues.size() == 0 && defaultValue != null) {
            this.log.warn("Names Metadata: using default value " + defaultValue);
            response.add(new TextTypeWrapperMutableBeanImpl(defaultLocale, defaultValue));
        } else {
            for (LocalizedText text : metadataValues) {
                this.log.debug("Adding metadata value " + text.getValue() + " " + text.getLocale());
                response.add(new TextTypeWrapperMutableBeanImpl(text.getLocale(), text.getValue()));
            }
        }
        return response;
    }

    private Table getAssociatedCodelist(Column column) {
        this.log.debug("Looking for table associated to column " + column.getLocalId());
        ColumnRelationship cr = column.getRelationship();
        this.log.debug("Relationship " + cr);
        Table response = null;
        if (cr != null) {
            this.log.debug("Loading referenced table...");
            Table relatedTable = this.cubeManager.getTable(cr.getTargetTableId());
            if (relatedTable.getTableType().getCode().equals("CODELIST")) {
                this.log.debug("Table found " + relatedTable.getName());
                response = relatedTable;
            } else {
                this.log.debug("Referenced table is not a codelist");
            }
        } else {
            this.log.debug("No related table found");
        }
        return response;
    }
}

