/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.statistical;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.csv4j.ParseException;
import net.sf.csv4j.ProcessingException;
import org.gcube.common.homelibrary.home.Home;
import org.gcube.common.homelibrary.home.HomeLibrary;
import org.gcube.common.homelibrary.home.exceptions.HomeNotFoundException;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.exceptions.UserNotFoundException;
import org.gcube.contentmanagement.blobstorage.resource.MyFile;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;
import org.gcube.data.analysis.dataminermanagercl.server.DataMinerService;
import org.gcube.data.analysis.dataminermanagercl.server.dmservice.SClient;
import org.gcube.data.analysis.dataminermanagercl.shared.data.output.FileResource;
import org.gcube.data.analysis.dataminermanagercl.shared.data.output.ImageResource;
import org.gcube.data.analysis.dataminermanagercl.shared.data.output.MapResource;
import org.gcube.data.analysis.dataminermanagercl.shared.data.output.ObjectResource;
import org.gcube.data.analysis.dataminermanagercl.shared.data.output.Resource;
import org.gcube.data.analysis.dataminermanagercl.shared.process.Operator;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.column.type.IdColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.ValidationColumnType;
import org.gcube.data.analysis.tabulardata.model.resources.InternalURI;
import org.gcube.data.analysis.tabulardata.model.resources.ResourceType;
import org.gcube.data.analysis.tabulardata.model.resources.TableResource;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.OperationHelper;
import org.gcube.data.analysis.tabulardata.operation.export.Utils;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.LeafParameter;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerStatus;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerWrapper;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.OperationAbortedException;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;
import org.gcube.data.analysis.tabulardata.operation.worker.results.WorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.results.resources.ImmutableTableResource;
import org.gcube.data.analysis.tabulardata.operation.worker.results.resources.ImmutableURIResult;
import org.gcube.data.analysis.tabulardata.operation.worker.results.resources.ResourceDescriptorResult;
import org.gcube.data.analysis.tabulardata.operation.worker.types.DataWorker;
import org.gcube.data.analysis.tabulardata.statistical.ImportFromStatisticalOperationFactory;
import org.gcube.data.analysis.tabulardata.statistical.ReservedWordsDictionary;
import org.gcube.data.analysis.tabulardata.statistical.StatisticalOperationFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Common {
    private static final Logger log = LoggerFactory.getLogger(Common.class);

    public static boolean isValidColumnName(Column col) throws ParseException, IOException, ProcessingException {
        String currentLabel = OperationHelper.retrieveColumnLabel((Column)col);
        return Common.isValidString(currentLabel);
    }

    public static boolean isValidString(String str) throws ParseException, IOException, ProcessingException {
        return str.matches("^[a-z_][a-z_0-9]*") && !ReservedWordsDictionary.getDictionary().isReservedKeyWord(str);
    }

    public static String fixColumnName(String columnName) throws ParseException, IOException, ProcessingException {
        String toReturn = columnName.replaceAll("\\W", "_").toLowerCase();
        if (Common.isValidString(toReturn)) {
            return toReturn;
        }
        return "_" + toReturn;
    }

    public static String fixColumnName(String columnName, String ... additionalReservedWords) throws ParseException, IOException, ProcessingException {
        String toCheck = Common.fixColumnName(columnName);
        String[] stringArray = additionalReservedWords;
        int n = additionalReservedWords.length;
        int n2 = 0;
        while (n2 < n) {
            String additional = stringArray[n2];
            if (toCheck.equalsIgnoreCase(additional)) {
                toCheck = "_" + toCheck;
            }
            ++n2;
        }
        return toCheck;
    }

    public static String fixColumnName(Column col, String ... additionalReservedWords) throws ParseException, IOException, ProcessingException {
        return Common.fixColumnName(OperationHelper.retrieveColumnLabel((Column)col), additionalReservedWords);
    }

    public static Map<ColumnLocalId, String> curateLabels(Table table, String ... additionalReservedWords) throws ParseException, IOException, ProcessingException {
        HashMap<ColumnLocalId, String> toReturn = new HashMap<ColumnLocalId, String>();
        HashMap<String, Integer> clashCounter = new HashMap<String, Integer>();
        for (Column col : table.getColumnsExceptTypes(new Class[]{IdColumnType.class, ValidationColumnType.class})) {
            String originalLabel = OperationHelper.retrieveColumnLabel((Column)col);
            String fixed = Common.fixColumnName(originalLabel, additionalReservedWords);
            if (clashCounter.containsKey(fixed)) {
                clashCounter.put(fixed, (Integer)clashCounter.get(fixed) + 1);
                fixed = String.valueOf(fixed) + "_" + clashCounter.get(fixed);
            } else {
                clashCounter.put(fixed, 1);
            }
            toReturn.put(col.getLocalId(), fixed);
        }
        return toReturn;
    }

    public static SClient getDMClient() throws Exception {
        return new DataMinerService().getClient();
    }

    public static Operator getOperator(OperationInvocation invocation) {
        Map param = (Map)OperationHelper.getParameter((LeafParameter)StatisticalOperationFactory.SM_ENTRIES, (OperationInvocation)invocation);
        return (Operator)param.get("operator");
    }

    public static URL getURLFromStorageId(String id) throws MalformedURLException, RemoteBackendException {
        return new URL(Utils.getStorageClient().getHttpUrl().RFile(id));
    }

    public static Home getHL() throws InternalErrorException, HomeNotFoundException, UserNotFoundException {
        return HomeLibrary.getHomeManagerFactory().getHomeManager().getHome();
    }

    public static void handleSMResource(String storageBasePath, Resource toHandle, List<ResourceDescriptorResult> results, Map<String, String> toSerializeValues, WorkerWrapper<DataWorker, WorkerResult> wrapper, boolean clearDataSpace, Home home) throws WorkerException {
        try {
            log.debug("Handling resource {} : {} [{}]", new Object[]{toHandle.getName(), toHandle.getResourceId(), toHandle.getResourceType()});
            switch (toHandle.getResourceType()) {
                case TABULAR: {
                    String toSetName = Common.retrieveFileName(toHandle.getResourceId(), toHandle.getName());
                    Table table = Common.importFromTableSpace(toHandle.getResourceId(), toSetName, wrapper, clearDataSpace);
                    results.add((ResourceDescriptorResult)new ImmutableTableResource(new TableResource(table.getId()), OperationHelper.retrieveTableLabel((Table)table), "Imported from SM", ResourceType.GENERIC_TABLE));
                    break;
                }
                case MAP: {
                    MapResource resource = (MapResource)toHandle;
                    for (Map.Entry entry : resource.getMap().entrySet()) {
                        Resource res = (Resource)entry.getValue();
                        Common.handleSMResource(storageBasePath, res, results, toSerializeValues, wrapper, clearDataSpace, home);
                    }
                    break;
                }
                case OBJECT: {
                    ObjectResource objRes = (ObjectResource)toHandle;
                    toSerializeValues.put(String.format("%s [%s]", objRes.getDescription(), objRes.getName()), objRes.getResourceId());
                    break;
                }
                case FILE: {
                    FileResource smFile = (FileResource)toHandle;
                    String toSetName = Common.retrieveFileName(smFile.getUrl(), smFile.getName());
                    if (smFile.getMimeType().equals("text/csv")) {
                        log.debug("Resource {}:ID {} is csv. Importing as table.", (Object)toSetName, (Object)smFile.getResourceId());
                        Table table = Common.importFromTableSpace(smFile.getUrl(), toSetName, wrapper, clearDataSpace);
                        results.add((ResourceDescriptorResult)new ImmutableTableResource(new TableResource(table.getId()), OperationHelper.retrieveTableLabel((Table)table), "Imported from SM", ResourceType.GENERIC_TABLE));
                        break;
                    }
                    log.debug("Resource {}:ID {} is mimetype {} . Importing as FILE .", new Object[]{smFile.getName(), smFile.getResourceId(), smFile.getMimeType()});
                    MyFile file = Common.storeUrl(storageBasePath, toSetName, smFile.getUrl());
                    results.add((ResourceDescriptorResult)new ImmutableURIResult(new InternalURI(new URI(file.getId()), smFile.getMimeType()), toSetName, smFile.getDescription(), ResourceType.GENERIC_FILE));
                    break;
                }
                case IMAGE: {
                    ImageResource imgRes = (ImageResource)toHandle;
                    String toSetName = Common.retrieveFileName(imgRes.getLink(), imgRes.getName());
                    MyFile file = Common.storeUrl(storageBasePath, toSetName, imgRes.getLink());
                    results.add((ResourceDescriptorResult)new ImmutableURIResult(new InternalURI(new URI(file.getId()), imgRes.getMimeType()), toSetName, imgRes.getDescription(), ResourceType.CHART));
                }
            }
        }
        catch (Exception e) {
            log.warn("Unable to get resource " + toHandle, (Throwable)e);
        }
    }

    private static Table importFromTableSpace(String resourceID, String tableName, WorkerWrapper<DataWorker, WorkerResult> wrapper, boolean clearDataSpace) throws WorkerException, OperationAbortedException {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put(ImportFromStatisticalOperationFactory.RESOURCE_ID.getIdentifier(), resourceID);
            params.put(ImportFromStatisticalOperationFactory.RESOURCE_NAME.getIdentifier(), tableName);
            params.put(ImportFromStatisticalOperationFactory.DELETE_REMOTE_RESOURCE.getIdentifier(), clearDataSpace);
            WorkerStatus status = wrapper.execute(null, null, params);
            if (!status.equals((Object)WorkerStatus.SUCCEDED)) {
                throw new WorkerException("Failed export to dataspace");
            }
            return ((WorkerResult)wrapper.getResult()).getResultTable();
        }
        catch (InvalidInvocationException e) {
            throw new WorkerException("Unable to import table from dataspace.", (Throwable)e);
        }
    }

    private static InputStream getStorageClientInputStream(String url) throws Exception {
        return new URL(url).openConnection().getInputStream();
    }

    private static MyFile storeUrl(String basePath, String fileName, String resourceUrl) throws RemoteBackendException, Exception {
        log.debug("Storing {} to {} from url {} ", (Object)fileName, (Object)resourceUrl);
        IClient client = Utils.getStorageClient();
        String id = client.put(true).LFile(Common.getStorageClientInputStream(resourceUrl)).RFile(String.valueOf(basePath) + "/" + fileName);
        log.debug("Copied to new id : " + id);
        return client.getMetaFile().RFile(id);
    }

    public static String retrieveFileName(String url, String defaultName) {
        try {
            String fileName = null;
            log.debug("Resolving name for url {} ", (Object)url);
            URL urlObj = new URL(url);
            HttpURLConnection connection = (HttpURLConnection)urlObj.openConnection();
            int status = connection.getResponseCode();
            if (status >= 300 && status < 400) {
                String newUrl = connection.getHeaderField("Location");
                log.debug("Following redirect from {} to {} ", (Object)url, (Object)newUrl);
                return Common.retrieveFileName(newUrl, defaultName);
            }
            String contentDisposition = connection.getHeaderField("Content-Disposition");
            Pattern regex = Pattern.compile("(?<=filename=\").*?(?=\")");
            Matcher regexMatcher = regex.matcher(contentDisposition);
            if (regexMatcher.find()) {
                fileName = regexMatcher.group();
            }
            if (fileName == null || fileName.isEmpty()) {
                throw new Exception("Filename was null or empty.");
            }
            return fileName;
        }
        catch (Throwable t) {
            log.debug("Unable to retrieve name from url {}, reverting to default {}.", new Object[]{url, defaultName, t});
            return defaultName;
        }
    }
}

