package org.gcube.data.analysis.tabulardata.operation.test;

import java.util.Map;

import javax.inject.Inject;

import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.operation.OperationDescriptor;
import org.gcube.data.analysis.tabulardata.operation.OperationScope;
import org.gcube.data.analysis.tabulardata.operation.invocation.InvocationCreator;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public abstract class OperationTester<T extends WorkerFactory> {

	FactoryChecker factoryChecker;

	WorkerChecker workerChecker;

	@Inject
	private CubeManager cubeManager;

	@Before
	public void setupFactoryChecker() {
		factoryChecker = new FactoryChecker(getFactory());
	}

	protected abstract WorkerFactory getFactory();

	@BeforeClass
	public static void beforeClass() {
		ScopeProvider.instance.set("/gcube/devsec");
	}

	private OperationInvocation createOperationInvocation() {
		OperationDescriptor descriptor = getFactory().getOperationDescriptor();
		InvocationCreator creator = InvocationCreator.getCreator(descriptor);
		creator.setParameters(getParameterInstances());
		OperationScope scope = descriptor.getScope();
		if (scope == OperationScope.TABLE || scope == OperationScope.COLUMN)
			creator.setTargetTable(getTargetTableId());
		if (scope == OperationScope.COLUMN)
			creator.setTargetColumn(getTargetColumnId());
		return creator.create();
	}

	@Test
	public final void testFactory() {
		factoryChecker.check();
	}

	protected abstract Map<String, Object> getParameterInstances();

	@Test
	public final void testWorker() throws InvalidInvocationException {
		OperationInvocation invocation = createOperationInvocation();
		workerChecker = new WorkerChecker(cubeManager, getFactory().createWorker(invocation));
		workerChecker.setCheckFallback(checkFallback());
		workerChecker.check();
	}

	protected boolean checkFallback(){
		return true;
	}

	protected abstract ColumnLocalId getTargetColumnId();

	protected abstract TableId getTargetTableId();

}
