/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.view.maps;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.column.type.DimensionColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.IdColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.ValidationColumnType;
import org.gcube.data.analysis.tabulardata.model.datatype.GeometryType;
import org.gcube.data.analysis.tabulardata.model.metadata.table.DatasetViewTableMetadata;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.OperationHelper;
import org.gcube.data.analysis.tabulardata.operation.OperationId;
import org.gcube.data.analysis.tabulardata.operation.OperationType;
import org.gcube.data.analysis.tabulardata.operation.factories.scopes.TableScopedWorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.Cardinality;
import org.gcube.data.analysis.tabulardata.operation.parameters.LeafParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.Parameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.BooleanParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.SimpleStringParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.TargetColumnParameter;
import org.gcube.data.analysis.tabulardata.operation.view.maps.GenerateMapWorker;
import org.gcube.data.analysis.tabulardata.operation.view.maps.GeoPublishingConfiguration;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;
import org.gcube.data.analysis.tabulardata.operation.worker.types.ResourceCreatorWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class GenerateMapFactory
extends TableScopedWorkerFactory<ResourceCreatorWorker> {
    private static final OperationId OPERATION_ID = new OperationId(1010L);
    private static Logger logger = LoggerFactory.getLogger(GenerateMapFactory.class);
    private CubeManager cubeManager;
    private DatabaseConnectionProvider connProvider;
    public static SimpleStringParameter mapName = new SimpleStringParameter("mapName", "Map Name", "Name by which publish the map.", Cardinality.ONE);
    public static TargetColumnParameter toCreateFeatureTypes = new TargetColumnParameter("feature", "Feature", "To create feature", new Cardinality(1, Integer.MAX_VALUE));
    public static final BooleanParameter useView = new BooleanParameter("useView", "Use View", "Use view columns values instead of dimensions", Cardinality.ONE);
    public static TargetColumnParameter toUseGeometry = new TargetColumnParameter("geom", "Geometry", "To use Geometry", Cardinality.OPTIONAL);
    public static SimpleStringParameter metaAbstract = new SimpleStringParameter("metaAbstract", "Abstract", "Abstract to publish the layer with", Cardinality.ONE);
    public static SimpleStringParameter metaPurpose = new SimpleStringParameter("metaPurpose", "Purpose", "Purpose of the layer", Cardinality.ONE);
    public static SimpleStringParameter user = new SimpleStringParameter("User", "User", "Author of the map", Cardinality.ONE);
    public static SimpleStringParameter metaCredits = new SimpleStringParameter("metaCredits", "Credits", "Credits", Cardinality.ONE);
    public static SimpleStringParameter keywords = new SimpleStringParameter("metaKeywords", "Metadata keywords", "Keywords to associate to this layer", new Cardinality(0, Integer.MAX_VALUE));
    private static final List<Parameter> params = Arrays.asList(mapName, toUseGeometry, toCreateFeatureTypes, useView, metaAbstract, metaPurpose, user, metaCredits, keywords);

    @Inject
    public GenerateMapFactory(CubeManager cubeManager, DatabaseConnectionProvider connProvider) {
        this.cubeManager = cubeManager;
        this.connProvider = connProvider;
    }

    public ResourceCreatorWorker createWorker(OperationInvocation arg0) throws InvalidInvocationException {
        this.performBaseChecks(arg0, this.cubeManager);
        this.checkParameters(arg0);
        GeoPublishingConfiguration geoConfig = null;
        try {
            geoConfig = GeoPublishingConfiguration.get();
        }
        catch (Exception e) {
            logger.error("Wrong GIS environement (Scope : " + ScopeProvider.instance.get() + ")", (Throwable)e);
            throw new InvalidInvocationException(arg0, "Environment doesn't support GIS features");
        }
        return new GenerateMapWorker(arg0, this.cubeManager, this.connProvider, geoConfig);
    }

    private void checkParameters(OperationInvocation arg0) throws InvalidInvocationException {
        Object toRepresentColumn;
        Table targetTable = this.cubeManager.getTable(arg0.getTargetTableId());
        if (!arg0.getParameterInstances().containsKey(toUseGeometry.getIdentifier())) {
            boolean foundGeom = false;
            for (Column col : targetTable.getColumnsExceptTypes(new Class[]{IdColumnType.class, ValidationColumnType.class})) {
                if (!(col.getDataType() instanceof GeometryType)) continue;
                if (!foundGeom) {
                    foundGeom = true;
                    continue;
                }
                throw new InvalidInvocationException(arg0, "Multiple geometry columns found in current table");
            }
            if (!foundGeom) {
                throw new InvalidInvocationException(arg0, "No Geometry column found");
            }
        } else {
            ColumnReference geomRef = (ColumnReference)OperationHelper.getParameter((LeafParameter)toUseGeometry, (OperationInvocation)arg0);
            Column geom = targetTable.getColumnById(geomRef.getColumnId());
            if (!(geom.getDataType() instanceof GeometryType)) {
                throw new InvalidInvocationException(arg0, "Invalid selected geometry column");
            }
        }
        if ((toRepresentColumn = arg0.getParameterInstances().get(toCreateFeatureTypes.getIdentifier())) instanceof ColumnReference) {
            if (!((ColumnReference)toRepresentColumn).getTableId().equals((Object)targetTable.getId())) {
                throw new InvalidInvocationException(arg0, "Invalid target column reference, wrong table id");
            }
        } else {
            for (ColumnReference ref : (Iterable)toRepresentColumn) {
                if (ref.getTableId().equals((Object)targetTable.getId())) continue;
                throw new InvalidInvocationException(arg0, "Invalid target column reference, wrong table id");
            }
        }
    }

    public Class<ResourceCreatorWorker> getWorkerType() {
        return ResourceCreatorWorker.class;
    }

    protected String getOperationDescription() {
        return "Generate a GIS layer from the table.";
    }

    protected String getOperationName() {
        return "Generate Map";
    }

    protected OperationType getOperationType() {
        return OperationType.RESOURCECREATOR;
    }

    protected OperationId getOperationId() {
        return OPERATION_ID;
    }

    protected List<Parameter> getParameters() {
        return params;
    }

    public String describeInvocation(OperationInvocation toDescribeInvocation) throws InvalidInvocationException {
        this.performBaseChecks(toDescribeInvocation, this.cubeManager);
        this.checkParameters(toDescribeInvocation);
        Table target = this.cubeManager.getTable(toDescribeInvocation.getTargetTableId());
        String features = OperationHelper.getColumnLabelsSnippet(GenerateMapFactory.getSelectedFeatureTypes(toDescribeInvocation, target, this.cubeManager));
        return "Generate " + features + " GIS features";
    }

    static List<Column> getSelectedFeatureTypes(OperationInvocation arg0, Table targetTable, CubeManager cubeManager) {
        boolean useView = (Boolean)OperationHelper.getParameter((LeafParameter)GenerateMapFactory.useView, (OperationInvocation)arg0);
        if (useView && targetTable.contains(DatasetViewTableMetadata.class)) {
            DatasetViewTableMetadata dsMeta = (DatasetViewTableMetadata)targetTable.getMetadata(DatasetViewTableMetadata.class);
            targetTable = cubeManager.getTable(dsMeta.getTargetDatasetViewTableId());
        }
        ArrayList<Column> toReturn = new ArrayList<Column>();
        Object toRepresentColumn = arg0.getParameterInstances().get(toCreateFeatureTypes.getIdentifier());
        if (toRepresentColumn instanceof ColumnReference) {
            toReturn.add(GenerateMapFactory.getColumn((ColumnReference)toRepresentColumn, targetTable, useView));
        } else {
            for (ColumnReference ref : (Iterable)toRepresentColumn) {
                toReturn.add(GenerateMapFactory.getColumn(ref, targetTable, useView));
            }
        }
        return toReturn;
    }

    private static Column getColumn(ColumnReference ref, Table table, boolean useView) {
        Column col = table.getColumnById(ref.getColumnId());
        if (useView && col.getColumnType() instanceof DimensionColumnType) {
            ColumnLocalId referredId = col.getRelationship().getTargetColumnId();
            return table.getColumnById(referredId);
        }
        return col;
    }
}

