/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.view.maps;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="PublishingParameters")
public class GeoPublishingParameters {
    private String workspace = "aquamaps";
    private String datastore = "aquamapsdb";
    private List<String> keywords = new ArrayList<String>(Arrays.asList("TDM", "Tabular Data Management"));
    private String crs = "GEOGCS[\"WGS 84\", DATUM[\"World Geodetic System 1984\", SPHEROID[\"WGS 84\", 6378137.0, 298.257223563, AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"]], PRIMEM[\"Greenwich\", 0.0, AUTHORITY[\"EPSG\",\"8901\"]],  UNIT[\"degree\", 0.017453292519943295],AXIS[\"Geodetic longitude\", EAST],  AXIS[\"Geodetic latitude\", NORTH],  AUTHORITY[\"EPSG\",\"4326\"]]";
    private String geometryFieldName = "the_geom";
    private String gNCategory = "datasets";
    private String gNStyleSheet = "_none_";
    private String tdmDataStoreFlag = "tdmDataStore";
    private String gisDBCategory = "Database";
    private String gisDBPlatformName = "postgis";
    private String accessPointName = "jdbc";
    private String urlPrefix = "jdbc:postgresql:";

    public GeoPublishingParameters() {
    }

    public GeoPublishingParameters(String workspace, String datastore, List<String> keywords, String crs, String geometryFieldName, String gNCategory, String gNStyleSheet, String tdmDataStoreFlag, String gisDBCategory, String gisDBPlatformName, String accessPointName, String urlPrefix) {
        this.workspace = workspace;
        this.datastore = datastore;
        this.keywords = keywords;
        this.crs = crs;
        this.geometryFieldName = geometryFieldName;
        this.gNCategory = gNCategory;
        this.gNStyleSheet = gNStyleSheet;
        this.tdmDataStoreFlag = tdmDataStoreFlag;
        this.gisDBCategory = gisDBCategory;
        this.gisDBPlatformName = gisDBPlatformName;
        this.accessPointName = accessPointName;
        this.urlPrefix = urlPrefix;
    }

    public String getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(String workspace) {
        this.workspace = workspace;
    }

    public String getDatastore() {
        return this.datastore;
    }

    public void setDatastore(String datastore) {
        this.datastore = datastore;
    }

    public List<String> getKeywords() {
        return this.keywords;
    }

    public void setKeywords(List<String> keywords) {
        this.keywords = keywords;
    }

    public String getCrs() {
        return this.crs;
    }

    public void setCrs(String crs) {
        this.crs = crs;
    }

    public String getGeometryFieldName() {
        return this.geometryFieldName;
    }

    public void setGeometryFieldName(String geometryFieldName) {
        this.geometryFieldName = geometryFieldName;
    }

    public String getgNCategory() {
        return this.gNCategory;
    }

    public void setgNCategory(String gNCategory) {
        this.gNCategory = gNCategory;
    }

    public String getgNStyleSheet() {
        return this.gNStyleSheet;
    }

    public void setgNStyleSheet(String gNStyleSheet) {
        this.gNStyleSheet = gNStyleSheet;
    }

    public String getTdmDataStoreFlag() {
        return this.tdmDataStoreFlag;
    }

    public void setTdmDataStoreFlag(String tdmDataStoreFlag) {
        this.tdmDataStoreFlag = tdmDataStoreFlag;
    }

    public String getGisDBCategory() {
        return this.gisDBCategory;
    }

    public void setGisDBCategory(String gisDBCategory) {
        this.gisDBCategory = gisDBCategory;
    }

    public String getGisDBPlatformName() {
        return this.gisDBPlatformName;
    }

    public void setGisDBPlatformName(String gisDBPlatformName) {
        this.gisDBPlatformName = gisDBPlatformName;
    }

    public String getAccessPointName() {
        return this.accessPointName;
    }

    public void setAccessPointName(String accessPointName) {
        this.accessPointName = accessPointName;
    }

    public String getUrlPrefix() {
        return this.urlPrefix;
    }

    public void setUrlPrefix(String urlPrefix) {
        this.urlPrefix = urlPrefix;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.accessPointName == null ? 0 : this.accessPointName.hashCode());
        result = 31 * result + (this.crs == null ? 0 : this.crs.hashCode());
        result = 31 * result + (this.datastore == null ? 0 : this.datastore.hashCode());
        result = 31 * result + (this.gNCategory == null ? 0 : this.gNCategory.hashCode());
        result = 31 * result + (this.gNStyleSheet == null ? 0 : this.gNStyleSheet.hashCode());
        result = 31 * result + (this.geometryFieldName == null ? 0 : this.geometryFieldName.hashCode());
        result = 31 * result + (this.gisDBCategory == null ? 0 : this.gisDBCategory.hashCode());
        result = 31 * result + (this.gisDBPlatformName == null ? 0 : this.gisDBPlatformName.hashCode());
        result = 31 * result + (this.keywords == null ? 0 : this.keywords.hashCode());
        result = 31 * result + (this.tdmDataStoreFlag == null ? 0 : this.tdmDataStoreFlag.hashCode());
        result = 31 * result + (this.urlPrefix == null ? 0 : this.urlPrefix.hashCode());
        result = 31 * result + (this.workspace == null ? 0 : this.workspace.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GeoPublishingParameters other = (GeoPublishingParameters)obj;
        if (this.accessPointName == null ? other.accessPointName != null : !this.accessPointName.equals(other.accessPointName)) {
            return false;
        }
        if (this.crs == null ? other.crs != null : !this.crs.equals(other.crs)) {
            return false;
        }
        if (this.datastore == null ? other.datastore != null : !this.datastore.equals(other.datastore)) {
            return false;
        }
        if (this.gNCategory == null ? other.gNCategory != null : !this.gNCategory.equals(other.gNCategory)) {
            return false;
        }
        if (this.gNStyleSheet == null ? other.gNStyleSheet != null : !this.gNStyleSheet.equals(other.gNStyleSheet)) {
            return false;
        }
        if (this.geometryFieldName == null ? other.geometryFieldName != null : !this.geometryFieldName.equals(other.geometryFieldName)) {
            return false;
        }
        if (this.gisDBCategory == null ? other.gisDBCategory != null : !this.gisDBCategory.equals(other.gisDBCategory)) {
            return false;
        }
        if (this.gisDBPlatformName == null ? other.gisDBPlatformName != null : !this.gisDBPlatformName.equals(other.gisDBPlatformName)) {
            return false;
        }
        if (this.keywords == null ? other.keywords != null : !this.keywords.equals(other.keywords)) {
            return false;
        }
        if (this.tdmDataStoreFlag == null ? other.tdmDataStoreFlag != null : !this.tdmDataStoreFlag.equals(other.tdmDataStoreFlag)) {
            return false;
        }
        if (this.urlPrefix == null ? other.urlPrefix != null : !this.urlPrefix.equals(other.urlPrefix)) {
            return false;
        }
        return !(this.workspace == null ? other.workspace != null : !this.workspace.equals(other.workspace));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("GeoPublishingParameters [workspace=");
        builder.append(this.workspace);
        builder.append(", datastore=");
        builder.append(this.datastore);
        builder.append(", keywords=");
        builder.append(this.keywords);
        builder.append(", crs=");
        builder.append(this.crs);
        builder.append(", geometryFieldName=");
        builder.append(this.geometryFieldName);
        builder.append(", gNCategory=");
        builder.append(this.gNCategory);
        builder.append(", gNStyleSheet=");
        builder.append(this.gNStyleSheet);
        builder.append(", tdmDataStoreFlag=");
        builder.append(this.tdmDataStoreFlag);
        builder.append(", gisDBCategory=");
        builder.append(this.gisDBCategory);
        builder.append(", gisDBPlatformName=");
        builder.append(this.gisDBPlatformName);
        builder.append(", accessPointName=");
        builder.append(this.accessPointName);
        builder.append(", urlPrefix=");
        builder.append(this.urlPrefix);
        builder.append("]");
        return builder.toString();
    }
}

