package org.gcube.data.analysis.tabulardata.service.tabular;

import java.util.List;

import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.service.exception.InvalidTabularResourceException;
import org.gcube.data.analysis.tabulardata.service.exception.NoSuchTableException;
import org.gcube.data.analysis.tabulardata.service.exception.NoSuchTabularResourceException;

public interface TabularResourceInterface {
	
	public List<TabularResource> getTabularResources();
	
	public List<TabularResource> getTabularResourcesByType(String type);
	
	public TabularResource getTabularResource(TabularResourceId id) throws NoSuchTabularResourceException;
	
	public void removeTabularResource(TabularResourceId id) throws NoSuchTabularResourceException;
	
	public TabularResource cloneTabularResource(TabularResourceId id) throws NoSuchTabularResourceException;
	
	public TabularResource cloneTabularResource(TabularResourceId id,TableId lastTableId) throws NoSuchTabularResourceException, NoSuchTableException;
	
	public TabularResource createTabularResource();
	
	public Table getLastTable(TabularResourceId id) throws NoSuchTabularResourceException, InvalidTabularResourceException, NoSuchTableException;
	
	public TabularResource share(TabularResourceId tabularResourceId, String ... users) throws NoSuchTabularResourceException;
	
	public TabularResource unshare(TabularResourceId tabularResourceId, String ... users) throws NoSuchTabularResourceException;

}
