/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.service.impl.operation.tasks;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.TaskStatus;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.WorkerStatus;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.operations.OperationExecution;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.tasks.TaskInfo;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.tasks.TaskStep;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.tasks.ValidationDescriptor;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.tasks.ValidationStep;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.service.impl.operation.tasks.TaskObserver;
import org.gcube.data.analysis.tabulardata.service.impl.operation.tasks.TaskUpdater;
import org.gcube.data.analysis.tabulardata.service.operation.Job;
import org.gcube.data.analysis.tabulardata.service.operation.Task;
import org.gcube.data.analysis.tabulardata.service.operation.TaskId;
import org.gcube.data.analysis.tabulardata.service.operation.TaskResult;
import org.gcube.data.analysis.tabulardata.service.operation.ValidationJob;
import org.gcube.data.analysis.tabulardata.service.tabular.TabularResource;

public class TaskObject
implements Task,
TaskObserver,
Serializable {
    private static final long serialVersionUID = 1L;
    private TaskId taskId;
    private TaskUpdater updater;
    private TaskInfo taskInfo;
    private List<Job> jobs = null;

    protected TaskObject(TaskInfo taskInfo) {
        this.taskInfo = taskInfo;
        this.taskId = new TaskId(taskInfo.getIdentifier());
    }

    public TaskId getTaskId() {
        return this.taskId;
    }

    private int getFinishedSubTasks() {
        int started = 0;
        for (Job job : this.getTaskJobs()) {
            if (job.getStatus() != WorkerStatus.SUCCEDED) continue;
            ++started;
        }
        return started;
    }

    public float getProgress() {
        this.checkUpdate();
        if (this.taskInfo.getTaskSteps().size() == 1) {
            return ((TaskStep)this.taskInfo.getTaskSteps().get(0)).getProgress();
        }
        int startedSubTask = this.getFinishedSubTasks();
        if (startedSubTask == 0) {
            return 0.0f;
        }
        return startedSubTask / this.taskInfo.getTaskSteps().size();
    }

    public TaskId getId() {
        return this.getTaskId();
    }

    public Date getStartTime() {
        this.checkUpdate();
        return this.taskInfo.getStartTime().getTime();
    }

    public Date getEndTime() {
        this.checkUpdate();
        if (this.taskInfo.getEndTime() == null) {
            return null;
        }
        return this.taskInfo.getEndTime().getTime();
    }

    public void abort() {
    }

    @Override
    public void notify(TaskInfo task) {
        if (task == null) {
            return;
        }
        this.taskInfo = task;
        ArrayList<Job> tempJobs = new ArrayList<Job>();
        if (this.taskInfo.getTaskSteps() != null) {
            for (TaskStep step : this.taskInfo.getTaskSteps()) {
                tempJobs.add(new JobImpl(step));
            }
        }
        this.jobs = tempJobs;
        if (this.getStatus().isFinal() && this.updater != null) {
            this.updater.unregisterObserver(this.getObserverIdentifier());
        }
    }

    @Override
    public String getObserverIdentifier() {
        return this.getId().getValue();
    }

    public TaskStatus getStatus() {
        this.checkUpdate();
        return this.taskInfo.getStatus();
    }

    public OperationExecution getInvocation() {
        return null;
    }

    public TaskResult getResult() {
        this.checkUpdate();
        return new TaskResult(){

            public Table getPrimaryTable() {
                if (TaskObject.this.taskInfo.getResult() != null) {
                    return TaskObject.this.taskInfo.getResult().getResultTable();
                }
                return null;
            }

            public List<TabularResource> getCollateralTabularResources() {
                return new ArrayList<TabularResource>();
            }
        };
    }

    public List<Job> getTaskJobs() {
        if (this.checkUpdate() || this.jobs == null) {
            ArrayList<Job> tempJobs = new ArrayList<Job>();
            if (this.taskInfo.getTaskSteps() != null) {
                for (TaskStep step : this.taskInfo.getTaskSteps()) {
                    tempJobs.add(new JobImpl(step));
                }
            }
            this.jobs = tempJobs;
        }
        return this.jobs;
    }

    public String getSubmitter() {
        return this.taskInfo.getSubmitter();
    }

    public TaskInfo.TaskType getTaskType() {
        return this.taskInfo.getType();
    }

    public Throwable getErrorCause() {
        return this.taskInfo.getErrorCause();
    }

    protected void setUpdater(TaskUpdater updater) {
        this.updater = updater;
        this.updater.registerObserver(this);
    }

    public String toString() {
        return "TaskObject [taskId=" + this.taskId + ", updater=" + this.updater + ", taskInfo=" + this.taskInfo + ", jobs=" + this.jobs + "]";
    }

    private boolean checkUpdate() {
        if (this.updater == null) {
            return false;
        }
        return this.updater.checkUpdate();
    }

    class JobImpl
    implements Job {
        private TaskStep step;

        public JobImpl(TaskStep step) {
            this.step = step;
        }

        public float getProgress() {
            return this.step.getProgress();
        }

        public WorkerStatus getStatus() {
            return this.step.getStatus();
        }

        public OperationExecution getInvocation() {
            return this.step.getSourceInvocation();
        }

        public Throwable getErrorMessage() {
            return this.step.getError();
        }

        public String getHumaReadableStatus() {
            return this.step.getHumanReadableStatus();
        }

        public String getDescription() {
            return this.step.getExecutionDescription();
        }

        public List<ValidationDescriptor> getValidations() {
            return this.step.getValidations();
        }

        public String toString() {
            return "JobImpl [step=" + this.step + "]";
        }

        public List<ValidationJob> getValidationJobs() {
            ArrayList<ValidationJob> validationJobs = new ArrayList<ValidationJob>();
            for (ValidationStep validationStep : this.step.getValidationSteps()) {
                validationJobs.add(new ValidationJobImpl(validationStep));
            }
            return validationJobs;
        }
    }

    class ValidationJobImpl
    implements ValidationJob {
        private ValidationStep step;

        public ValidationJobImpl(ValidationStep step) {
            this.step = step;
        }

        public float getProgress() {
            return this.step.getProgress();
        }

        public WorkerStatus getStatus() {
            return this.step.getStatus();
        }

        public Throwable getErrorMessage() {
            return this.step.getError();
        }

        public String getHumaReadableStatus() {
            return this.step.getHumanReadableStatus();
        }

        public String getDescription() {
            return this.step.getExecutionDescription();
        }

        public String toString() {
            return "ValidationJob [" + this.step + "]";
        }
    }
}

