package org.gcube.data.analysis.tabulardata.service.operation;

import java.util.Date;
import java.util.List;

import org.gcube.data.analysis.tabulardata.operation.worker.ActivityStatus;
import org.gcube.data.analysis.tabulardata.operation.worker.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.worker.JobResult;

public class DelegateTask implements Task {

	Task delegate;

	public TaskId getId() {
		return delegate.getId();
	}

	public OperationInvocation getSourceInvocation() {
		return delegate.getSourceInvocation();
	}

	public List<TaskJob> getTaskJobs() {
		return delegate.getTaskJobs();
	}

	public JobResult getResult() {
		return delegate.getResult();
	}

	public float getProgress() {
		return delegate.getProgress();
	}

	public ActivityStatus getStatus() {
		return delegate.getStatus();
	}

	public Date getStartTime() {
		return delegate.getStartTime();
	}

	public Date getEndTime() {
		return delegate.getEndTime();
	}

	public String getInvokerUsername() {
		return delegate.getInvokerUsername();
	}

	public void abort() {
		delegate.abort();
	}

	public DelegateTask(Task delegate) {
		this.delegate = delegate;
	}

	public synchronized Task getDelegate() {
		return delegate;
	}

	public synchronized void setDelegate(Task delegate) {
		this.delegate = delegate;
	}

	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("DelegateOperation [getId()=");
		builder.append(getId());
		builder.append(", getSourceOperationInvocation()=");
		builder.append(getSourceInvocation());
		builder.append(", getOperationSteps()=");
		builder.append(getTaskJobs());
		builder.append(", getOperationResult()=");
		builder.append(getResult());
		builder.append(", getProgress()=");
		builder.append(getProgress());
		builder.append(", getStatus()=");
		builder.append(getStatus());
		builder.append(", getStartTime()=");
		builder.append(getStartTime());
		builder.append(", getEndTime()=");
		builder.append(getEndTime());
		builder.append(", getInvokerUsername()=");
		builder.append(getInvokerUsername());
		builder.append("]");
		return builder.toString();
	}

}
