package org.gcube.data.analysis.tabulardata.service;

import java.util.List;

import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.operation.worker.EligibleOperation;
import org.gcube.data.analysis.tabulardata.operation.worker.OperationInvocation;
import org.gcube.data.analysis.tabulardata.query.parameters.QueryFilter;
import org.gcube.data.analysis.tabulardata.query.parameters.QueryOrder;
import org.gcube.data.analysis.tabulardata.query.parameters.QueryPage;
import org.gcube.data.analysis.tabulardata.service.exception.InvalidInvocationException;
import org.gcube.data.analysis.tabulardata.service.exception.NoSuchColumnException;
import org.gcube.data.analysis.tabulardata.service.exception.NoSuchTableException;
import org.gcube.data.analysis.tabulardata.service.exception.NoSuchTabularResourceException;
import org.gcube.data.analysis.tabulardata.service.exception.NoSuchTaskException;
import org.gcube.data.analysis.tabulardata.service.operation.OperationInterface;
import org.gcube.data.analysis.tabulardata.service.operation.OperationInterfaceMock;
import org.gcube.data.analysis.tabulardata.service.operation.Task;
import org.gcube.data.analysis.tabulardata.service.operation.Task.TaskId;
import org.gcube.data.analysis.tabulardata.service.query.QueryInterface;
import org.gcube.data.analysis.tabulardata.service.query.QueryInterfaceMock;
import org.gcube.data.analysis.tabulardata.service.tabular.TabularResource;
import org.gcube.data.analysis.tabulardata.service.tabular.TabularResourceId;
import org.gcube.data.analysis.tabulardata.service.tabular.TabularResourceInterface;
import org.gcube.data.analysis.tabulardata.service.tabular.TabularResourceInterfaceMock;

public class TabularDataServiceMock implements TabularDataService {

	private QueryInterface queryInterface = new QueryInterfaceMock();
	
	public Task getTask(TaskId operationId, TabularResourceId tabularResourceId) throws NoSuchTaskException, NoSuchTabularResourceException {
		return operationInterface.getTask(operationId, tabularResourceId);
	}

	public List<EligibleOperation> getCapabilities() {
		return operationInterface.getCapabilities();
	}

	public List<EligibleOperation> getCapabilities(TabularResourceId tabularResourceId) throws NoSuchTabularResourceException {
		return operationInterface.getCapabilities(tabularResourceId);
	}

	public List<EligibleOperation> getCapabilities(TabularResourceId tabularResourceId, ColumnLocalId columnId)
			throws NoSuchTabularResourceException, NoSuchColumnException {
		return operationInterface.getCapabilities(tabularResourceId, columnId);
	}

	public Task execute(OperationInvocation invocation, TabularResourceId targetTabularResourceId)
			throws NoSuchTabularResourceException, InvalidInvocationException {
		return operationInterface.execute(invocation, targetTabularResourceId);
	}

	public Table rollbackToTable(TabularResourceId tabularResourceId, TableId toTableId) throws NoSuchTabularResourceException,
			NoSuchTableException {
		return operationInterface.rollbackToTable(tabularResourceId, toTableId);
	}

	public List<Task> getTasks(TabularResourceId tabularResourceId) throws NoSuchTabularResourceException {
		return operationInterface.getTasks(tabularResourceId);
	}

	private TabularResourceInterface tabularResourceInterface = new TabularResourceInterfaceMock();
	
	private OperationInterface operationInterface = new OperationInterfaceMock();

	public List<TabularResource> getTabularResources() {
		return tabularResourceInterface.getTabularResources();
	}

	public TabularResource getTabularResource(TabularResourceId id) throws NoSuchTabularResourceException {
		return tabularResourceInterface.getTabularResource(id);
	}

	public void removeTabularResource(TabularResourceId id) throws NoSuchTabularResourceException {
		tabularResourceInterface.removeTabularResource(id);
	}

	public TabularResource cloneTabularResource(TabularResourceId id) throws NoSuchTabularResourceException {
		return tabularResourceInterface.cloneTabularResource(id);
	}

	public TabularResource cloneTabularResource(TabularResourceId id, TableId lastTableId) throws NoSuchTabularResourceException, NoSuchTableException {
		return tabularResourceInterface.cloneTabularResource(id, lastTableId);
	}

	public TabularResource createTabularResource() {
		return tabularResourceInterface.createTabularResource();
	}

	public String queryAsJson(TableId tableId, QueryPage page, QueryFilter filter, QueryOrder order)
			throws NoSuchTableException {
		return queryInterface.queryAsJson(tableId, page, filter, order);
	}

//	public Table getLastTable(TabularResourceId tabularResourceId) throws NoSuchTabularResourceException {
//		return queryInterface.getLastTable(tabularResourceId);
//	}

	public Table getTable(TableId tableId) throws NoSuchTableException {
		return queryInterface.getTable(tableId);
	}

	public String queryAsJson(TableId tableId, QueryPage page, QueryFilter filter) throws NoSuchTableException {
		return queryInterface.queryAsJson(tableId, page, filter);
	}

	public int getQueryLenght(TableId tableId, QueryFilter filter) throws NoSuchTableException {
		return queryInterface.getQueryLenght(tableId, filter);
	}

	public String queryAsJson(TableId tableId, QueryPage page, QueryOrder order) throws NoSuchTableException {
		return queryInterface.queryAsJson(tableId, page, order);
	}

	public String queryAsJson(TableId tableId, QueryPage page) throws NoSuchTableException {
		return queryInterface.queryAsJson(tableId, page);
	}
	
	

}
