package org.gcube.data.analysis.tabulardata.service.query;

import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.query.parameters.QueryFilter;
import org.gcube.data.analysis.tabulardata.query.parameters.QueryOrder;
import org.gcube.data.analysis.tabulardata.query.parameters.QueryPage;
import org.gcube.data.analysis.tabulardata.service.ServiceState;
import org.gcube.data.analysis.tabulardata.service.exception.NoSuchTableException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryInterfaceMock implements QueryInterface {

	private static Logger log = LoggerFactory.getLogger(QueryInterfaceMock.class);

	@Override
	public String queryAsJson(TableId tableId, QueryPage page, QueryFilter filter, QueryOrder order) throws NoSuchTableException {
		// TODO-LF filtering
		return queryAsJson(tableId, page);
	}

	@Override
	public String queryAsJson(TableId tableId, QueryPage page, QueryFilter filter) throws NoSuchTableException {
		// TODO-LF filtering
		return queryAsJson(tableId, page);
	}

	@Override
	public String queryAsJson(TableId tableId, QueryPage page, QueryOrder order) throws NoSuchTableException {
		// TODO-LF ordering
		return queryAsJson(tableId, page);
	}

	@Override
	public String queryAsJson(TableId tableId, QueryPage page) throws NoSuchTableException {
		getTable(tableId);
		try {
			JSONArray data = ServiceState.codelistData.getJSONArray("rows");
			JSONObject resultJson = new JSONObject();
			JSONArray jsonArray = new JSONArray();

			int start = page.getOffset();
			int end = page.getOffset() + page.getPageSize();

			for (int i = start; i < end; i++) {
				jsonArray.put(data.get(i));
			}
			resultJson.put("rows", jsonArray);
			return resultJson.toString();
		} catch (JSONException e) {
			log.error("Unable to parse JSON document", e);
			return null;
		}
	}

	@Override
	public Table getTable(TableId tableId) throws NoSuchTableException {
		for (Table table : ServiceState.tables) {
			if (tableId.equals(table.getId()))
				return table;
		}
		throw new NoSuchTableException(tableId);
	}

	@Override
	public int getQueryLenght(TableId tableId, QueryFilter filter) throws NoSuchTableException {
		getTable(tableId);
		try {
			// TODO-LF Add filter support
			JSONArray jsonArray = ServiceState.codelistData.getJSONArray("rows");
			return jsonArray.length();
		} catch (Exception e) {
			log.error("Unable to retrieve total lenght", e);
			return 0;
		}
	}
		
}
