package org.gcube.data.analysis.tabulardata.service.tabular;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.gcube.data.analysis.tabulardata.metadata.ArrayListMetadataHolder;
import org.gcube.data.analysis.tabulardata.metadata.NoSuchMetadataException;
import org.gcube.data.analysis.tabulardata.service.tabular.metadata.TabularResourceMetadata;

import com.google.common.collect.Lists;

public class ImmutableTabularResource implements TabularResource {

	/**
	 * 
	 */
	private static final long serialVersionUID = -57876758536246103L;

	private static long lastId = 0;

	private TabularResourceId id;

	private List<HistoryStep> history = Lists.newArrayList();
	
	private ArrayListMetadataHolder<TabularResourceMetadata> metadataDelegate = new ArrayListMetadataHolder<TabularResourceMetadata>();
	
	public ImmutableTabularResource(TabularResource copy) {
		this.id = new TabularResourceId(lastId++);
		this.history = copy.getHistory();
		this.metadataDelegate.metadata = new ArrayList<TabularResourceMetadata>(copy.getAllMetadata());
	}

	public ImmutableTabularResource() {
		this.id = new TabularResourceId(lastId++);
	}

	public ImmutableTabularResource(List<HistoryStep> history, TabularResourceMetadata... metadata) {
		this.id = new TabularResourceId(lastId++);
		this.history = history;
		this.metadataDelegate.metadata = Lists.newArrayList(metadata);
	}
	
	public ImmutableTabularResource(List<HistoryStep> history, Collection<TabularResourceMetadata> metadata) {
		this.id = new TabularResourceId(lastId++);
		this.history = history;
		this.metadataDelegate.metadata = Lists.newArrayList(metadata);
	}

	@Override
	public TabularResourceId getId() {
		return id;
	}

	@Override
	public List<HistoryStep> getHistory() {
		return history;
	}
	
	

	public <C extends TabularResourceMetadata> C getMetadata(Class<C> metadataType) throws NoSuchMetadataException {
		return metadataDelegate.getMetadata(metadataType);
	}

	public void removeMetadata(Class<? extends TabularResourceMetadata> metadataType) {
		metadataDelegate.removeMetadata(metadataType);
	}

	public void setMetadata(TabularResourceMetadata metadata) {
		metadataDelegate.setMetadata(metadata);
	}

	public Collection<TabularResourceMetadata> getAllMetadata() {
		return metadataDelegate.getAllMetadata();
	}

	public void setAllMetadata(Collection<TabularResourceMetadata> metadata) {
		metadataDelegate.setAllMetadata(metadata);
	}

	public void removeAllMetadata() {
		metadataDelegate.removeAllMetadata();
	}
	
	

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((history == null) ? 0 : history.hashCode());
		result = prime * result + ((id == null) ? 0 : id.hashCode());
		result = prime * result + ((metadataDelegate == null) ? 0 : metadataDelegate.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		ImmutableTabularResource other = (ImmutableTabularResource) obj;
		if (history == null) {
			if (other.history != null)
				return false;
		} else if (!history.equals(other.history))
			return false;
		if (id == null) {
			if (other.id != null)
				return false;
		} else if (!id.equals(other.id))
			return false;
		if (metadataDelegate == null) {
			if (other.metadataDelegate != null)
				return false;
		} else if (!metadataDelegate.equals(other.metadataDelegate))
			return false;
		return true;
	}

	
	
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("TabularResourceImpl [id=");
		builder.append(id);
		builder.append(", history=");
		builder.append(history);
		builder.append(", metadata=");
		builder.append(getAllMetadata());
		builder.append("]");
		return builder.toString();
	}

}
