/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.service.query;

import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.query.parameters.QueryFilter;
import org.gcube.data.analysis.tabulardata.query.parameters.QueryOrder;
import org.gcube.data.analysis.tabulardata.query.parameters.QueryPage;
import org.gcube.data.analysis.tabulardata.service.ServiceState;
import org.gcube.data.analysis.tabulardata.service.exception.NoSuchTableException;
import org.gcube.data.analysis.tabulardata.service.query.QueryInterface;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryInterfaceMock
implements QueryInterface {
    private static Logger log = LoggerFactory.getLogger(QueryInterfaceMock.class);

    public String queryAsJson(TableId tableId, QueryPage page, QueryFilter filter, QueryOrder order) throws NoSuchTableException {
        return this.queryAsJson(tableId, page);
    }

    public String queryAsJson(TableId tableId, QueryPage page, QueryFilter filter) throws NoSuchTableException {
        return this.queryAsJson(tableId, page);
    }

    public String queryAsJson(TableId tableId, QueryPage page, QueryOrder order) throws NoSuchTableException {
        return this.queryAsJson(tableId, page);
    }

    public String queryAsJson(TableId tableId, QueryPage page) throws NoSuchTableException {
        this.getTable(tableId);
        try {
            JSONArray data = ServiceState.codelistData.getJSONArray("rows");
            JSONObject resultJson = new JSONObject();
            JSONArray jsonArray = new JSONArray();
            int start = page.getOffset();
            int end = page.getOffset() + page.getPageSize();
            int i = start;
            while (i < end) {
                jsonArray.put(data.get(i));
                ++i;
            }
            resultJson.put("rows", (Object)jsonArray);
            return resultJson.toString();
        }
        catch (JSONException e) {
            log.error("Unable to parse JSON document", (Throwable)e);
            return null;
        }
    }

    public Table getTable(TableId tableId) throws NoSuchTableException {
        for (Table table : ServiceState.tables) {
            if (!tableId.equals((Object)table.getId())) continue;
            return table;
        }
        throw new NoSuchTableException(tableId);
    }

    public int getQueryLenght(TableId tableId, QueryFilter filter) throws NoSuchTableException {
        this.getTable(tableId);
        try {
            JSONArray jsonArray = ServiceState.codelistData.getJSONArray("rows");
            return jsonArray.length();
        }
        catch (Exception e) {
            log.error("Unable to retrieve total lenght", (Throwable)e);
            return 0;
        }
    }
}

