package org.gcube.data.analysis.tabulardata.service.operation;

import java.util.Date;
import java.util.List;

import org.gcube.data.analysis.tabulardata.operation.worker.ActivityStatus;
import org.gcube.data.analysis.tabulardata.operation.worker.JobResult;
import org.gcube.data.analysis.tabulardata.operation.worker.OperationInvocation;
import org.gcube.data.analysis.tabulardata.service.tabular.TabularResourceId;

public class DelegateTask implements Task {

	Task delegate;

	public DelegateTask(Task delegate) {
		this.delegate = delegate;
	}

	public synchronized Task getDelegate() {
		return delegate;
	}

	public synchronized void setDelegate(Task delegate) {
		this.delegate = delegate;
	}

	@Override
	public TaskId getId() {
		return delegate.getId();
	}

	@Override
	public OperationInvocation getSourceInvocation() {
		return delegate.getSourceInvocation();
	}

	@Override
	public List<TaskJob> getTaskJobs() {
		return delegate.getTaskJobs();
	}

	@Override
	public JobResult getResult() {
		return delegate.getResult();
	}

	@Override
	public float getProgress() {
		return delegate.getProgress();
	}

	@Override
	public ActivityStatus getStatus() {
		return delegate.getStatus();
	}

	@Override
	public Date getStartTime() {
		return delegate.getStartTime();
	}

	@Override
	public Date getEndTime() {
		return delegate.getEndTime();
	}

	@Override
	public String getInvokerUsername() {
		return delegate.getInvokerUsername();
	}

	@Override
	public List<TabularResourceId> getCollateralTabularResourceIds() {
		return delegate.getCollateralTabularResourceIds();
	}

	@Override
	public void abort() {
		delegate.abort();
	}

	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("DelegateOperation [getId()=");
		builder.append(getId());
		builder.append(", getSourceOperationInvocation()=");
		builder.append(getSourceInvocation());
		builder.append(", getOperationSteps()=");
		builder.append(getTaskJobs());
		builder.append(", getOperationResult()=");
		builder.append(getResult());
		builder.append(", getProgress()=");
		builder.append(getProgress());
		builder.append(", getStatus()=");
		builder.append(getStatus());
		builder.append(", getStartTime()=");
		builder.append(getStartTime());
		builder.append(", getEndTime()=");
		builder.append(getEndTime());
		builder.append(", getInvokerUsername()=");
		builder.append(getInvokerUsername());
		builder.append("]");
		return builder.toString();
	}

}
