/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.service.operation;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.model.table.type.CodelistTableType;
import org.gcube.data.analysis.tabulardata.operation.parameters.Cardinality;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.RegexpStringParameter;
import org.gcube.data.analysis.tabulardata.operation.worker.ActivityStatus;
import org.gcube.data.analysis.tabulardata.operation.worker.EligibleOperation;
import org.gcube.data.analysis.tabulardata.operation.worker.ImmutableJob;
import org.gcube.data.analysis.tabulardata.operation.worker.ImmutableJobResult;
import org.gcube.data.analysis.tabulardata.operation.worker.Job;
import org.gcube.data.analysis.tabulardata.operation.worker.JobResult;
import org.gcube.data.analysis.tabulardata.operation.worker.OperationDescriptor;
import org.gcube.data.analysis.tabulardata.operation.worker.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.worker.Worker;
import org.gcube.data.analysis.tabulardata.service.ServiceState;
import org.gcube.data.analysis.tabulardata.service.exception.InvalidInvocationException;
import org.gcube.data.analysis.tabulardata.service.exception.NoSuchColumnException;
import org.gcube.data.analysis.tabulardata.service.exception.NoSuchTableException;
import org.gcube.data.analysis.tabulardata.service.exception.NoSuchTabularResourceException;
import org.gcube.data.analysis.tabulardata.service.exception.NoSuchTaskException;
import org.gcube.data.analysis.tabulardata.service.operation.DelegateTask;
import org.gcube.data.analysis.tabulardata.service.operation.ImmutableTask;
import org.gcube.data.analysis.tabulardata.service.operation.ImmutableTaskJob;
import org.gcube.data.analysis.tabulardata.service.operation.OperationInterface;
import org.gcube.data.analysis.tabulardata.service.operation.Task;
import org.gcube.data.analysis.tabulardata.service.operation.TaskJob;
import org.gcube.data.analysis.tabulardata.service.operation.TaskJobClassifier;
import org.gcube.data.analysis.tabulardata.service.tabular.HistoryStep;
import org.gcube.data.analysis.tabulardata.service.tabular.HistoryStepImpl;
import org.gcube.data.analysis.tabulardata.service.tabular.TabularResource;
import org.gcube.data.analysis.tabulardata.service.tabular.TabularResourceId;

public class OperationInterfaceMock
implements OperationInterface {
    private static long operationCounter = 0L;
    static EligibleOperation sdmxCodelistExportCapability;

    public List<EligibleOperation> getCapabilities() {
        return ServiceState.voidCapabilities;
    }

    private EligibleOperation getSDMXCodelistExportCapability(TableId tableId) {
        OperationDescriptor operationDescriptor = new OperationDescriptor(new OperationDescriptor.OperationId(201L), "Sdmx codelist export", "SDMX codelist export", OperationDescriptor.OperationScope.TABLE, OperationDescriptor.OperationType.EXPORT);
        ArrayList<RegexpStringParameter> parameters = new ArrayList<RegexpStringParameter>();
        parameters.add(new RegexpStringParameter("registryBaseUrl", "Registry REST URL", "Target SDMX Registry REST Service base URL", Cardinality.ONE, "^https?://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]"));
        parameters.add(new RegexpStringParameter("agency", "Agency", "SDMX Agency", Cardinality.ONE, "[A-z0-9_-]+"));
        parameters.add(new RegexpStringParameter("id", "Id", "SDMX Codelist id", Cardinality.ONE, "[A-z0-9_-]+"));
        parameters.add(new RegexpStringParameter("version", "Version", "SDMX Codelist version", Cardinality.ONE, "[0-9]+\\.[0-9]+"));
        return new EligibleOperation(operationDescriptor, parameters, tableId);
    }

    public List<EligibleOperation> getCapabilities(TabularResourceId tabularResourceId) throws NoSuchTabularResourceException {
        ArrayList result = Lists.newArrayList();
        TabularResource tr = ServiceState.getTabularResourceById(tabularResourceId);
        Table lastStepTable = ((HistoryStep)tr.getHistory().get(tr.getHistory().size() - 1)).getResultTable();
        if (lastStepTable.getTableType().equals((Object)new CodelistTableType())) {
            result.add(this.getSDMXCodelistExportCapability(lastStepTable.getId()));
        }
        return result;
    }

    public List<EligibleOperation> getCapabilities(TabularResourceId tabularResourceId, ColumnLocalId columnId) throws NoSuchTabularResourceException, NoSuchColumnException {
        return ServiceState.columnCapabilities;
    }

    public synchronized Task execute(OperationInvocation invocation, TabularResourceId targetTabularResourceId) throws NoSuchTabularResourceException, InvalidInvocationException {
        ServiceState.getTabularResourceById(targetTabularResourceId);
        List<Task> operations = this.getTasks(targetTabularResourceId);
        this.checkOperations(operations);
        FakeWorker worker = new FakeWorker(invocation);
        DelegateTask delegateOperation = new DelegateTask((Task)new ImmutableTask(new Task.TaskId(String.valueOf(operationCounter++)), invocation, null, null, 0.0f, ActivityStatus.INITIALIZING, new Date(), null, "user"));
        ServiceState.operations.get(targetTabularResourceId).add(delegateOperation);
        new Thread(new OperationUpdater(worker, delegateOperation, targetTabularResourceId, invocation)).start();
        return delegateOperation;
    }

    private void checkOperations(List<Task> operations) throws InvalidInvocationException {
        if (operations.isEmpty()) {
            return;
        }
        Task lastOperation = operations.get(operations.size() - 1);
        switch (lastOperation.getStatus()) {
            case WAITING: 
            case INITIALIZING: 
            case IN_PROGRESS: {
                throw new InvalidInvocationException("Cannot start operation while one is still in progress");
            }
        }
    }

    public Table rollbackToTable(TabularResourceId tabularResourceId, TableId toTableId) throws NoSuchTabularResourceException, NoSuchTableException {
        throw new UnsupportedOperationException("Rollback is not supported yet");
    }

    public List<Task> getTasks(TabularResourceId tabularResourceId) throws NoSuchTabularResourceException {
        return ServiceState.getOperations(tabularResourceId);
    }

    public Task getTask(Task.TaskId operationId, TabularResourceId tabularResourceId) throws NoSuchTaskException, NoSuchTabularResourceException {
        if (operationId == null) {
            throw new IllegalArgumentException("Must provide a non null operation id");
        }
        if (tabularResourceId == null) {
            throw new IllegalArgumentException("Must provide a non null tabular resource id");
        }
        List<Task> operations = ServiceState.getOperations(tabularResourceId);
        for (Task operation : operations) {
            if (!operation.getId().equals((Object)operationId)) continue;
            return operation;
        }
        throw new NoSuchTaskException(tabularResourceId, operationId);
    }

    public class FakeWorker
    implements Worker {
        private ImmutableJob job;
        private OperationInvocation invocation;

        public FakeWorker(OperationInvocation invocation) {
            this.invocation = invocation;
            this.job = new ImmutableJob(0.0f, ActivityStatus.INITIALIZING, invocation);
        }

        public void run() {
            try {
                int i = 0;
                while (i < 9) {
                    this.job = new ImmutableJob(this.job.getProgress() + 0.1f, ActivityStatus.IN_PROGRESS, this.invocation);
                    Thread.sleep(1000L);
                    ++i;
                }
                this.job = new ImmutableJob(1.0f, ActivityStatus.SUCCEDED, this.invocation, (JobResult)new ImmutableJobResult(ServiceState.tables.get(0)));
            }
            catch (Exception e) {
                System.err.println("Error during execution of fakeworker");
            }
        }

        public ImmutableJob getJob() {
            return this.job;
        }
    }

    public class OperationUpdater
    implements Runnable {
        Worker worker;
        DelegateTask delegateOperation;
        TabularResourceId tabularResourceId;
        OperationInvocation invocation;

        public OperationUpdater(Worker worker, DelegateTask delegateOperation, TabularResourceId tabularResourceId, OperationInvocation invocation) {
            this.worker = worker;
            this.delegateOperation = delegateOperation;
            this.tabularResourceId = tabularResourceId;
            this.invocation = invocation;
        }

        @Override
        public void run() {
            ImmutableTask newTask;
            new Thread((Runnable)this.worker).start();
            ImmutableJob job = null;
            do {
                try {
                    job = this.worker.getJob();
                    ImmutableTaskJob taskStep = new ImmutableTaskJob((Job)job, TaskJobClassifier.PROCESSING);
                    newTask = new ImmutableTask(this.delegateOperation.getId(), this.delegateOperation.getSourceInvocation(), (List)Lists.newArrayList((Object[])new TaskJob[]{taskStep}), null, taskStep.getProgress(), ActivityStatus.IN_PROGRESS, this.delegateOperation.getStartTime(), null, this.delegateOperation.getInvokerUsername());
                    this.delegateOperation.setDelegate((Task)newTask);
                    Thread.sleep(1000L);
                }
                catch (Exception e) {
                    System.err.println("Error during execution of operation updater");
                }
            } while (job.getStatus() == ActivityStatus.INITIALIZING || job.getStatus() == ActivityStatus.IN_PROGRESS || job.getStatus() == ActivityStatus.WAITING);
            ImmutableTaskJob taskJob = new ImmutableTaskJob((Job)this.worker.getJob(), TaskJobClassifier.PROCESSING);
            try {
                TabularResource tr = ServiceState.getTabularResourceById(this.tabularResourceId);
                HistoryStepImpl historyStep = new HistoryStepImpl(this.invocation, job.getResult().getOutput(), TaskJobClassifier.PROCESSING);
                tr.getHistory().add(historyStep);
            }
            catch (Exception e) {
                throw new RuntimeException("Tabular Resource not found! This should not happen, check your code.");
            }
            newTask = new ImmutableTask(this.delegateOperation.getId(), this.delegateOperation.getSourceInvocation(), (List)Lists.newArrayList((Object[])new TaskJob[]{taskJob}), taskJob.getResult(), taskJob.getProgress(), ActivityStatus.SUCCEDED, this.delegateOperation.getStartTime(), new Date(), this.delegateOperation.getInvokerUsername());
            this.delegateOperation.setDelegate((Task)newTask);
        }
    }
}

