/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.commons.templates.model.columns;

import java.util.Arrays;
import java.util.List;
import org.gcube.data.analysis.tabulardata.commons.templates.model.columns.DimensionReference;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.datatype.DateType;
import org.gcube.data.analysis.tabulardata.model.datatype.IntegerType;
import org.gcube.data.analysis.tabulardata.model.datatype.NumericType;
import org.gcube.data.analysis.tabulardata.model.datatype.TextType;

public enum ColumnCategory {
    ATTRIBUTE(null, IntegerType.class, NumericType.class, TextType.class, DateType.class),
    DIMENSION(DimensionReference.class, IntegerType.class),
    MEASURE(null, IntegerType.class, NumericType.class),
    CODENAME(null, TextType.class),
    CODEDESCRIPTION(null, TextType.class),
    ANNOTATION(null, TextType.class),
    CODE(null, TextType.class);

    private List<Class<? extends DataType>> classes;
    private boolean referenceRequired;
    private Class<?> referenceClass;

    private ColumnCategory(Class<?> referenceClass, Class<? extends DataType> ... classes) {
        this.classes = Arrays.asList(classes);
        this.referenceRequired = referenceClass != null;
        this.referenceClass = referenceClass;
    }

    public List<Class<? extends DataType>> getAllowedClasses() {
        return this.classes;
    }

    public boolean isReferenceRequired() {
        return this.referenceRequired;
    }

    public Class<?> getReferenceClass() {
        return this.referenceClass;
    }
}

