package org.gcube.data.analysis.tabulardata.commons.webservice;

import java.util.List;

import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.jws.soap.SOAPBinding.ParameterStyle;
import javax.jws.soap.SOAPBinding.Style;
import javax.jws.soap.SOAPBinding.Use;

import org.gcube.data.analysis.tabulardata.commons.utils.Constants;
import org.gcube.data.analysis.tabulardata.commons.webservice.exception.NoSuchTabularResourceException;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.resources.ResourceDescriptor;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.resources.ResourceType;

@WebService(targetNamespace=Constants.RESOURCE_TNS)
@SOAPBinding(style = Style.DOCUMENT, use=Use.LITERAL)
public interface ResourceManager {

	public static final String SERVICE_NAME = "resourcemanager";
	
	@SOAPBinding(parameterStyle=ParameterStyle.WRAPPED)
	List<ResourceDescriptor> getResourcePerTabularResource(long tabularResourceId) throws NoSuchTabularResourceException;
	
	@SOAPBinding(parameterStyle=ParameterStyle.WRAPPED)
	List<ResourceDescriptor> getResourcePerTabularResourceAndType(long tabularResourceId, ResourceType type) throws NoSuchTabularResourceException;
}
