package org.gcube.data.analysis.tabulardata.commons.webservice.types;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

import org.gcube.data.analysis.tabulardata.commons.rules.RuleScope;
import org.gcube.data.analysis.tabulardata.expression.Expression;

@XmlRootElement
@XmlAccessorType(XmlAccessType.FIELD)
public class RuleDescription {

	@XmlElement
	private long id;
	@XmlElement
	private String name;
	@XmlElement
	private String description;
	@XmlElement
	private RuleScope scope;
	@XmlElement
	private Expression rule;
	
	@SuppressWarnings("unused")
	private RuleDescription(){}
	
	public RuleDescription(long id, String name, String description, Expression rule, RuleScope scope) {
		super();
		this.id = id;
		this.name = name;
		this.description = description;
		this.rule = rule;
		this.scope = scope;
	}

	/**
	 * @return the id
	 */
	public long getId() {
		return id;
	}

	/**
	 * @return the name
	 */
	public String getName() {
		return name;
	}

	/**
	 * @return the description
	 */
	public String getDescription() {
		return description;
	}

	/**
	 * @return the rule
	 */
	public Expression getRule() {
		return rule;
	}

	/**
	 * @return the scope
	 */
	public RuleScope getScope() {
		return scope;
	}
	
}
