/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.commons.templates.model.actions.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.data.analysis.tabulardata.commons.templates.model.actions.ColumnCreatorAction;
import org.gcube.data.analysis.tabulardata.commons.templates.model.columns.ColumnCategory;
import org.gcube.data.analysis.tabulardata.commons.templates.model.columns.TemplateColumn;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.operation.parameters.Cardinality;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.ColumnTypeParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.DataTypeParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.ExpressionParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.LocalizedTextParameter;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class AddColumnAction
extends ColumnCreatorAction {
    private static final long serialVersionUID = 4829645296356074095L;
    public static final DataTypeParameter DATA_TYPE = new DataTypeParameter("dataType", "Data Type", "To set data type", Cardinality.OPTIONAL);
    public static final ColumnTypeParameter COLUMN_TYPE = new ColumnTypeParameter("columnType", "Column type", "The type of the new column", Cardinality.ONE);
    public static final LocalizedTextParameter LABEL = new LocalizedTextParameter("label", "label", "To set label", Cardinality.OPTIONAL);
    public static final ExpressionParameter VALUE_PARAMETER = new ExpressionParameter("value", "To set Value", "The value to be set in new column.", Cardinality.OPTIONAL);
    private static final long ADDCOLUMN_OP_ID = 1005L;
    private TemplateColumn<?> column;
    private Expression initialValue;
    public static final List<ColumnCategory> allowedColumn = Arrays.asList(ColumnCategory.ATTRIBUTE, ColumnCategory.ANNOTATION, ColumnCategory.CODE, ColumnCategory.CODEDESCRIPTION, ColumnCategory.CODENAME, ColumnCategory.MEASURE);

    public AddColumnAction(TemplateColumn<?> column, Expression initialValue) {
        if (!allowedColumn.contains((Object)column.getColumnType())) {
            throw new IllegalArgumentException("column category not allowed");
        }
        this.column = column;
        this.initialValue = initialValue;
    }

    @Override
    public Long getIdentifier() {
        return 1005L;
    }

    @Override
    public Map<String, Object> getParameters() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        TemplateColumn<?> templateColumn = this.column;
        try {
            parameters.put(DATA_TYPE.getIdentifier(), templateColumn.getValueType().newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalArgumentException("unexpected exception", e);
        }
        parameters.put(COLUMN_TYPE.getIdentifier(), templateColumn.getColumnType().getModelType());
        parameters.put(VALUE_PARAMETER.getIdentifier(), this.initialValue);
        return parameters;
    }

    public static List<ColumnCategory> getAllowedcolumn() {
        return allowedColumn;
    }

    public TemplateColumn<?> getColumn() {
        return this.column;
    }

    @Override
    public List<TemplateColumn<?>> getCreatedColumns() {
        ArrayList toReturn = new ArrayList(1);
        toReturn.add(this.column);
        return toReturn;
    }

    @Override
    public boolean usesExpression() {
        return true;
    }
}

