package org.gcube.data.analysis.tabulardata.commons.templates.model.actions.impl;

import static org.gcube.data.analysis.tabulardata.expression.dsl.Texts.concat;
import static org.gcube.data.analysis.tabulardata.expression.dsl.Types.text;
import static org.gcube.data.analysis.tabulardata.expression.dsl.Types.textPlaceholder;

import java.util.Arrays;
import java.util.List;
import java.util.UUID;

import org.gcube.data.analysis.tabulardata.commons.templates.model.Utils;
import org.gcube.data.analysis.tabulardata.commons.templates.model.TemplateAction;
import org.gcube.data.analysis.tabulardata.commons.templates.model.actions.GroupAction;
import org.gcube.data.analysis.tabulardata.commons.templates.model.columns.ColumnCategory;
import org.gcube.data.analysis.tabulardata.commons.templates.model.columns.TemplateColumn;
import org.gcube.data.analysis.tabulardata.commons.utils.TimeDimensionReference;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.model.datatype.TextType;
import org.gcube.data.analysis.tabulardata.model.time.PeriodType;
import org.gcube.data.analysis.tabulardata.model.time.TimeConstants;

public class GenerateTimeDimensionGroup implements GroupAction {

	private TemplateColumn<TextType> year;
	private TemplateColumn<TextType> month;
	private TemplateColumn<TextType> quarter;
	private TemplateColumn<TextType> day;
	
	private String id = UUID.randomUUID().toString();
	
	private PeriodType periodType;
	private String formatId ;
	private String label;
	
	
	public GenerateTimeDimensionGroup(TemplateColumn<TextType> year, String label) {
		super();
		this.year = year;
		this.periodType = PeriodType.YEAR;
		this.formatId = TimeConstants.ISO_YEAR.getId();
		this.label = label;
	}
	
	public GenerateTimeDimensionGroup(TemplateColumn<TextType> year,
			TemplateColumn<TextType> secondParam, boolean isMonth, String label) {
		super();
		this.year = year;
		if (isMonth){
			this.month = secondParam;
			this.periodType = PeriodType.MONTH;
			this.formatId = TimeConstants.ISO_MONTH.getId();
		}else{
			this.quarter = secondParam;
			this.periodType = PeriodType.QUARTER;
			this.formatId = TimeConstants.ISO_QUARTER.getId();
		}
		this.label = label;
	}
	
	public GenerateTimeDimensionGroup(TemplateColumn<TextType> year,
			TemplateColumn<TextType> month, TemplateColumn<TextType> day, String label) {
		this.year = year;
		this.month = month;
		this.day = day;
		this.periodType = PeriodType.DAY;
		this.formatId = TimeConstants.ISO_DATE_ANY_SEP.getId();
		this.label = label;
	}

	@Override
	public List<TemplateAction<Long>> getActions() {
		Expression expr;
		if (this.day!=null)
			expr = concat(concat(concat(concat(textPlaceholder(year.getId()), text("-")),textPlaceholder(month.getId())),text("-")),textPlaceholder(day.getId()));
		else if (this.quarter!=null) expr = concat(concat(textPlaceholder(year.getId()), text("-Q")),textPlaceholder(quarter.getId()));
		else if (this.month!=null) expr = concat(concat(textPlaceholder(year.getId()), text("-")),textPlaceholder(month.getId()));
		else expr = textPlaceholder(year.getId());
		TemplateColumn<TextType> newColumn = new TemplateColumn<TextType>(ColumnCategory.ATTRIBUTE, TextType.class, Utils.TEXT_FORMAT_REFERENCE );
		newColumn.setLabel(label);
		AddColumnAction addColumn = new AddColumnAction(newColumn, expr);
		addColumn.setBelogsToGroup(getGroupId());
		
		ChangeToTimeDimensionAction changeCol = new ChangeToTimeDimensionAction(addColumn.getCreatedColumns().get(0), new TimeDimensionReference(periodType, formatId));
		changeCol.setBelogsToGroup(getGroupId());
		
		return Arrays.asList((TemplateAction<Long>)addColumn, changeCol);
	}

	@Override
	public String getGroupId() {
		return id;
	}
		
	
	
}
