/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.commons.templates.model.actions.impl;

import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.gcube.data.analysis.tabulardata.commons.templates.model.TemplateAction;
import org.gcube.data.analysis.tabulardata.commons.templates.model.Utils;
import org.gcube.data.analysis.tabulardata.commons.templates.model.actions.GroupAction;
import org.gcube.data.analysis.tabulardata.commons.templates.model.actions.impl.AddColumnAction;
import org.gcube.data.analysis.tabulardata.commons.templates.model.actions.impl.ChangeToTimeDimensionAction;
import org.gcube.data.analysis.tabulardata.commons.templates.model.columns.ColumnCategory;
import org.gcube.data.analysis.tabulardata.commons.templates.model.columns.TemplateColumn;
import org.gcube.data.analysis.tabulardata.commons.utils.TimeDimensionReference;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.expression.dsl.Texts;
import org.gcube.data.analysis.tabulardata.expression.dsl.Types;
import org.gcube.data.analysis.tabulardata.model.datatype.TextType;
import org.gcube.data.analysis.tabulardata.model.time.PeriodType;
import org.gcube.data.analysis.tabulardata.model.time.TimeConstants;

public class GenerateTimeDimensionGroup
implements GroupAction {
    private TemplateColumn<TextType> year;
    private TemplateColumn<TextType> month;
    private TemplateColumn<TextType> quarter;
    private TemplateColumn<TextType> day;
    private String id = UUID.randomUUID().toString();
    private PeriodType periodType;
    private String formatId;
    private String label;

    public GenerateTimeDimensionGroup(TemplateColumn<TextType> year, String label) {
        this.year = year;
        this.periodType = PeriodType.YEAR;
        this.formatId = TimeConstants.ISO_YEAR.getId();
        this.label = label;
    }

    public GenerateTimeDimensionGroup(TemplateColumn<TextType> year, TemplateColumn<TextType> secondParam, boolean isMonth, String label) {
        this.year = year;
        if (isMonth) {
            this.month = secondParam;
            this.periodType = PeriodType.MONTH;
            this.formatId = TimeConstants.ISO_MONTH.getId();
        } else {
            this.quarter = secondParam;
            this.periodType = PeriodType.QUARTER;
            this.formatId = TimeConstants.ISO_QUARTER.getId();
        }
        this.label = label;
    }

    public GenerateTimeDimensionGroup(TemplateColumn<TextType> year, TemplateColumn<TextType> month, TemplateColumn<TextType> day, String label) {
        this.year = year;
        this.month = month;
        this.day = day;
        this.periodType = PeriodType.DAY;
        this.formatId = TimeConstants.ISO_DATE_ANY_SEP.getId();
        this.label = label;
    }

    @Override
    public List<TemplateAction<Long>> getActions() {
        Object expr = this.day != null ? Texts.concat((Expression)Texts.concat((Expression)Texts.concat((Expression)Texts.concat((Expression)this.getYearExpression(), (Expression)Types.text((String)"-")), (Expression)this.getMonthExpression()), (Expression)Types.text((String)"-")), (Expression)this.getDayExpression()) : (this.quarter != null ? Texts.concat((Expression)Texts.concat((Expression)this.getYearExpression(), (Expression)Types.text((String)"-Q")), (Expression)this.getQuarterExpression()) : (this.month != null ? Texts.concat((Expression)Texts.concat((Expression)Types.textPlaceholder((String)this.year.getId()), (Expression)Types.text((String)"-")), (Expression)this.getMonthExpression()) : this.getYearExpression()));
        TemplateColumn<TextType> newColumn = new TemplateColumn<TextType>(ColumnCategory.ATTRIBUTE, TextType.class, Utils.TEXT_FORMAT_REFERENCE);
        newColumn.setLabel(this.label);
        AddColumnAction addColumn = new AddColumnAction(newColumn, (Expression)expr);
        addColumn.setBelogsToGroup(this.getGroupId());
        ChangeToTimeDimensionAction changeCol = new ChangeToTimeDimensionAction(addColumn.getCreatedColumns().get(0), new TimeDimensionReference(this.periodType, this.formatId));
        changeCol.setBelogsToGroup(this.getGroupId());
        return Arrays.asList(addColumn, changeCol);
    }

    @Override
    public String getGroupId() {
        return this.id;
    }

    private Expression getMonthExpression() {
        return Texts.regexprReplace((Expression)Types.textPlaceholder((String)this.month.getId()), (String)"[^\\d]*(\\d)[^\\d]", (String)"0\\1");
    }

    private Expression getDayExpression() {
        return Texts.regexprReplace((Expression)Types.textPlaceholder((String)this.day.getId()), (String)"[^\\d]*(\\d)[^\\d]", (String)"0\\1");
    }

    private Expression getYearExpression() {
        return Texts.regexprReplace((Expression)Types.textPlaceholder((String)this.year.getId()), (String)"[^\\d](\\d\\d\\d\\d)[^\\d]", (String)"\\1");
    }

    private Expression getQuarterExpression() {
        return Texts.regexprReplace((Expression)Types.textPlaceholder((String)this.quarter.getId()), (String)"[^\\d]*(\\d)[^\\d]", (String)"\\1");
    }
}

