/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.commons.templates.model.actions.arguments;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.gcube.data.analysis.tabulardata.commons.templates.model.Representable;
import org.gcube.data.analysis.tabulardata.commons.templates.model.actions.arguments.ArgumentInstance;
import org.gcube.data.analysis.tabulardata.commons.templates.model.actions.arguments.ArgumentType;
import org.gcube.data.analysis.tabulardata.commons.templates.model.actions.arguments.ChangeHandler;
import org.gcube.data.analysis.tabulardata.commons.templates.model.actions.arguments.ContainerInstance;
import org.gcube.data.analysis.tabulardata.commons.templates.model.actions.arguments.DependencyDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArgumentDescriptor<T extends Representable> {
    private static final Logger log = LoggerFactory.getLogger(ArgumentDescriptor.class);
    private String identifier = UUID.randomUUID().toString();
    private String name;
    private String description;
    private boolean multiArgument;
    private List<T> selection;
    private ArgumentType argumentType;
    private Set<DependencyDescriptor> dependsOnArguments = new HashSet<DependencyDescriptor>();
    private boolean dependsOnItself = false;
    private Map<String, ChangeHandler<T>> handlerMap = new HashMap<String, ChangeHandler<T>>();
    private ArgumentInstance<T> instance;
    private ContainerInstance containerInstance;

    public ArgumentDescriptor(String name, String description, boolean multiArgument, ArgumentType argumentType) {
        this.name = name;
        this.description = description;
        this.multiArgument = multiArgument;
        this.argumentType = argumentType;
    }

    public ArgumentInstance<T> createInstance(ContainerInstance belongsTo) {
        ArgumentInstance<T> instance = new ArgumentInstance<T>(this);
        instance.setHandlerMap(this.handlerMap);
        instance.setContainerInstanceBelongsTo(belongsTo);
        return instance;
    }

    public void setDependsOn(ArgumentDescriptor<?> argument, ChangeHandler<T> handler, DependencyDescriptor.DependencyType type) {
        log.trace("[" + this.getName() + "] added as depend on " + argument.getIdentifier() + " named " + argument.getName());
        this.dependsOnArguments.add(new DependencyDescriptor(argument.getIdentifier(), type));
        if (argument.getIdentifier() == this.getIdentifier()) {
            log.trace("depends on itself " + this.getName());
            this.dependsOnItself = true;
        }
        this.handlerMap.put(argument.getIdentifier(), handler);
    }

    public String toString() {
        return "ArgumentDescriptor [identifier=" + this.identifier + ", name=" + this.name + "]";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ArgumentDescriptor)) {
            return false;
        }
        ArgumentDescriptor other = (ArgumentDescriptor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$identifier = this.getIdentifier();
        String other$identifier = other.getIdentifier();
        return !(this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier));
    }

    public boolean canEqual(Object other) {
        return other instanceof ArgumentDescriptor;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        String $identifier = this.getIdentifier();
        result = result * 31 + ($identifier == null ? 0 : $identifier.hashCode());
        return result;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isMultiArgument() {
        return this.multiArgument;
    }

    public List<T> getSelection() {
        return this.selection;
    }

    public void setSelection(List<T> selection) {
        this.selection = selection;
    }

    public ArgumentType getArgumentType() {
        return this.argumentType;
    }

    public Set<DependencyDescriptor> getDependsOnArguments() {
        return this.dependsOnArguments;
    }

    public boolean isDependsOnItself() {
        return this.dependsOnItself;
    }

    public ArgumentInstance<T> getInstance() {
        return this.instance;
    }

    protected void setContainerInstance(ContainerInstance containerInstance) {
        this.containerInstance = containerInstance;
    }
}

