package org.gcube.data.analysis.tabulardata.model.column.factories;

import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.type.AnnotationColumnType;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.datatype.TextType;
import org.gcube.data.analysis.tabulardata.model.metadata.column.DataLocaleMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.common.LocalizedText;

public class AnnotationColumnFactory extends BaseColumnFactory {

	public static Column create(LocalizedText label){
		return create(new AnnotationColumnType(), label, new TextType(256)); 
	}
	
	public static Column create(LocalizedText label, DataLocaleMetadata dataLocale){
		Column column =  create(new AnnotationColumnType(), label, new TextType(256));
		column.setMetadata(dataLocale);
		return column;
	}
	
	public static Column create(LocalizedText label,DataType dataType){
		return create(new AnnotationColumnType(), label, dataType); 
	}
	
}
