package org.gcube.data.analysis.tabulardata.model.column;

import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.relationship.ColumnRelationship;

import com.google.common.base.Optional;

public class AttributeColumn extends Column {
	
	String label;
	
	Optional<String> name = Optional.absent();
	
	DataType dataType;

	/**
	 * 
	 */
	private static final long serialVersionUID = 5838984034587971220L;

	public AttributeColumn(String label, DataType dataType) {
		this.label = label;
		this.dataType = dataType;
	}

	public AttributeColumn(String label, String name, DataType dataType) {
		this(label,dataType);
		this.name = Optional.of(name);
	}

	@Override
	public String getLabel() {
		return label;
	}

	@Override
	public void setLabel(String label) {
		this.label = label;
	}

	@Override
	public boolean hasName() {
		return name.isPresent();
	}

	@Override
	public String getName() {
		return name.get();
	}

	@Override
	public DataType getDataType() {
		return dataType;
	}

	@Override
	public boolean hasRelationship() {
		return false;
	}

	@Override
	public ColumnRelationship getRelationship() {
		throw new IllegalStateException("Columns of type " + getColumnType() + " do not support relationships");
	}

	@Override
	public ColumnType getColumnType() {
		return ColumnType.ATTRIBUTE;
	}

	@Override
	public void setName(String name) {
		this.name=Optional.of(name);
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((dataType == null) ? 0 : dataType.hashCode());
		result = prime * result + ((label == null) ? 0 : label.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		AttributeColumn other = (AttributeColumn) obj;
		if (dataType == null) {
			if (other.dataType != null)
				return false;
		} else if (!dataType.equals(other.dataType))
			return false;
		if (label == null) {
			if (other.label != null)
				return false;
		} else if (!label.equals(other.label))
			return false;
		return true;
	}

}
