package org.gcube.data.analysis.tabulardata.model.table;

import java.util.Collection;
import java.util.List;

import org.gcube.data.analysis.tabulardata.model.column.AttributeColumn;
import org.gcube.data.analysis.tabulardata.model.column.CodelistRefColumn;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.IdColumn;
import org.gcube.data.analysis.tabulardata.model.column.MeasureColumn;
import org.gcube.data.analysis.tabulardata.model.column.SystemColumn;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;

/**
 * A dataset is a table containing statistical data, optionally linked to
 * dimensions (codelists). It contains one {@link IdColumn}, zero or more
 * {@link AttributeColumn}, {@link MeasureColumn}, {@link CodelistRefColumn},
 * {@link SystemColumn}.
 * 
 * @author "Luigi Fortunati"
 * 
 */
public class Dataset extends Table {

	private Collection<Column> columns = Lists.newArrayList();
	
	public Dataset(Dataset dataset) {
		super(dataset.getId(), dataset.getName());
		columns = dataset.getColumns();
	}
	
	public Dataset(String name, Collection<Column> columns) {
		super(name);
		this.columns = columns;
	}
		
	public Dataset(long id, String name, Collection<Column> columns){
		super(id,name);
		this.columns = columns;
	}



	@Override
	public List<Column> getColumns() {
		return ImmutableList.copyOf(columns);
	}

	@Override
	public TableType getTableType() {
		return TableType.DATASET;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = super.hashCode();
		result = prime * result + ((columns == null) ? 0 : columns.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (!super.equals(obj))
			return false;
		if (getClass() != obj.getClass())
			return false;
		Dataset other = (Dataset) obj;
		if (columns == null) {
			if (other.columns != null)
				return false;
		} else if (!columns.equals(other.columns))
			return false;
		return true;
	}

}
