/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.model.metadata;

import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import org.gcube.data.analysis.tabulardata.model.metadata.CubeMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.MetadataHolder;

public class HashMapMetadataHolder
implements MetadataHolder {
    private Map<String, CubeMetadata<Serializable>> metadata = Maps.newHashMap();

    private String getMetadataKey(Class metadataType) {
        return metadataType.getName();
    }

    @Override
    public <C extends CubeMetadata<? extends Serializable>> C getMetadata(Class<C> metadataType) {
        return (C)this.metadata.get(this.getMetadataKey(metadataType));
    }

    @Override
    public void removeMetadata(Class<? extends CubeMetadata<? extends Serializable>> metadataType) {
        this.metadata.remove(this.getMetadataKey(metadataType));
    }

    @Override
    public void setMetadata(CubeMetadata<? extends Serializable> metadata) {
        this.metadata.put(this.getMetadataKey(metadata.getClass()), metadata);
    }

    @Override
    public Collection<CubeMetadata<Serializable>> getAllMetadata() {
        return this.metadata.values();
    }

    @Override
    public void removeAllMetadata() {
        this.metadata = Maps.newHashMap();
    }

    @Override
    public void setMetadata(Collection<? extends CubeMetadata<? extends Serializable>> metadataObjects) {
        for (CubeMetadata<? extends Serializable> cubeMetadata : metadataObjects) {
            this.setMetadata(cubeMetadata);
        }
    }

    @Override
    public <T extends Serializable> T getMetadataObject(Class<? extends CubeMetadata<T>> metadataType) {
        return this.getMetadata(metadataType).getMetadataObject();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.metadata == null ? 0 : ((Object)this.metadata).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HashMapMetadataHolder other = (HashMapMetadataHolder)obj;
        return !(this.metadata == null ? other.metadata != null : !((Object)this.metadata).equals(other.metadata));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("HashMapMetadataHolder [metadata=");
        builder.append(this.metadata);
        builder.append("]");
        return builder.toString();
    }
}

