package org.gcube.data.analysis.tabulardata.model.relationship;

import org.gcube.data.analysis.tabulardata.model.reference.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.reference.TableReference;

public class TableRelationshipImpl implements TableRelationship {
	
	private static final long serialVersionUID = 8369191690239495474L;
	
	private ColumnRelationship delegate;
	
	private	ColumnReference sourceTableForeignKeyColumnReference;

	public TableRelationshipImpl(ColumnReference sourceForeignKeyColumnReference,ColumnRelationship columnRelationship) {
		super();
		this.sourceTableForeignKeyColumnReference = sourceForeignKeyColumnReference;
		this.delegate = columnRelationship;
	}

	@Override
	public boolean isChildParentRelationship() {
		return delegate.isChildParentRelationship();
	}

	@Override
	public TableReference getTargetTableRef() {
		return delegate.getTargetTableRef();
	}

	@Override
	public ColumnReference getTargetPKRef() {
		return delegate.getTargetPKRef();
	}

	@Override
	public ColumnReference getSourceTableFKRef() {
		return sourceTableForeignKeyColumnReference;
	}

	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("TableRelationshipImpl [delegate=");
		builder.append(delegate);
		builder.append(", sourceTableForeignKeyColumnReference=");
		builder.append(sourceTableForeignKeyColumnReference);
		builder.append(", isChildParentRelationship()=");
		builder.append(isChildParentRelationship());
		builder.append(", getTargetTableRef()=");
		builder.append(getTargetTableRef());
		builder.append(", getTargetPKRef()=");
		builder.append(getTargetPKRef());
		builder.append(", getSourceTableFKRef()=");
		builder.append(getSourceTableFKRef());
		builder.append("]");
		return builder.toString();
	}

}
