package org.gcube.data.analysis.tabulardata.expression.composite;

import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlSeeAlso;

import org.gcube.data.analysis.tabulardata.expression.CompositeExpression;
import org.gcube.data.analysis.tabulardata.expression.Expression;

@XmlSeeAlso(And.class)
public abstract class MultipleArgsBoolCondition extends CompositeExpression {

//	@XmlElementRefs({ @XmlElementRef(type = And.class), @XmlElementRef(type = Or.class),
//			@XmlElementRef(type = IsNull.class), @XmlElementRef(type = ValueIsIn.class),
//			@XmlElementRef(type = Equals.class), @XmlElementRef(type = GreaterThan.class),
//			@XmlElementRef(type = LessThan.class), @XmlElementRef(type = NotEquals.class),
//			@XmlElementRef(type = TextContains.class), @XmlElementRef(type = TextEquals.class),
//			@XmlElementRef(type = TextMatchSQLRegexp.class), })
//	@XmlElement
	List<Expression> arguments = new ArrayList<Expression>();

	@Deprecated
	protected MultipleArgsBoolCondition() {
	}

	public MultipleArgsBoolCondition(List<Expression> arguments) {
		this.arguments = arguments;
		checkArgsNumber();
	}

	public void checkArgsNumber() {
		if (arguments.size() <= 1)
			throw new RuntimeException("Invalid number of arguments: " + arguments.size() + ". At least 2 are needed.");
	}

	public List<Expression> getChilds() {
		return arguments;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((arguments == null) ? 0 : arguments.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		MultipleArgsBoolCondition other = (MultipleArgsBoolCondition) obj;
		if (arguments == null) {
			if (other.arguments != null)
				return false;
		} else if (!arguments.equals(other.arguments))
			return false;
		return true;
	}

}