/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.model.datatype;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.datatype.geometry.GeometryShape;

@XmlRootElement(name="Geometry")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class GeometryType
extends DataType {
    private static final long serialVersionUID = 522898962047621730L;
    @XmlAttribute(name="srid")
    private int srid = 0;
    @XmlAttribute
    private GeometryShape type;
    @XmlAttribute
    private int dimensions;

    public GeometryType() {
        this.setSrid(0);
        this.setType(GeometryShape.GEOMETRY);
        this.setDimensions(2);
    }

    public GeometryType(int srid, int dimensions) {
        this.setSrid(srid);
        this.type = GeometryShape.GEOMETRY;
    }

    public GeometryType(int dimensions) {
        this.type = GeometryShape.GEOMETRY;
        this.setDimensions(dimensions);
    }

    public GeometryType(int srid, GeometryShape type, int dimensions) {
        this.setSrid(srid);
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        this.type = type;
        this.setDimensions(dimensions);
    }

    public GeometryType(GeometryShape type, int dimensions) {
        this.type = type;
        this.setDimensions(dimensions);
    }

    public int getSrid() {
        return this.srid;
    }

    public void setSrid(int srid) {
        if (srid < 0) {
            throw new IllegalArgumentException("System Referencing id must be greater or equal than 0");
        }
        this.srid = srid;
    }

    public GeometryShape getGeometryType() {
        return this.type;
    }

    public void setType(GeometryShape type) {
        this.type = type;
    }

    public int getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(int dimensions) {
        if (dimensions < 2 || dimensions > 4) {
            throw new IllegalArgumentException("Dimension must be an integer between 2 and 4.");
        }
        this.dimensions = dimensions;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.dimensions;
        result = 31 * result + this.srid;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GeometryType other = (GeometryType)obj;
        if (this.dimensions != other.dimensions) {
            return false;
        }
        if (this.srid != other.srid) {
            return false;
        }
        return this.type == other.type;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Geometry(");
        builder.append(this.srid);
        builder.append(",");
        builder.append((Object)this.type);
        builder.append(",");
        builder.append(this.dimensions);
        builder.append(")");
        return builder.toString();
    }
}

