package org.gcube.data.analysis.tabulardata.model.datatype;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="Text")
@XmlAccessorType(XmlAccessType.FIELD)
public class TextType extends DataType{
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 3012818814370962508L;
	
	
	private int lenght;
	
	/**
	 * Creates a Text data type with a maximum lenght of 256 characters
	 */
	public TextType() {
		lenght = 256;
	}
	
	/**
	 * Creates a Text data type with a given maximum lenght
	 * @param lenght the number of allowed maximum characters
	 */
	public TextType(int lenght) {
		super();
		this.lenght = lenght;
	}

	public int getLenght() {
		return lenght;
	}	

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + lenght;
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		TextType other = (TextType) obj;
		if (lenght != other.lenght)
			return false;
		return true;
	}

	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("Text [lenght=");
		builder.append(lenght);
		builder.append("]");
		return builder.toString();
	}

}
