package org.gcube.data.analysis.tabulardata.model.metadata.column;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;

@XmlRootElement
@XmlAccessorType(XmlAccessType.FIELD)
public class MetadataValidationReference implements ColumnMetadata {
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 9022171393208058355L;

	private ColumnLocalId validationReferenceColumn;
	
	
	public MetadataValidationReference(ColumnLocalId columnId){
		this.validationReferenceColumn = columnId;
	}
	
	@SuppressWarnings("unused")
	private MetadataValidationReference(){}	
	
	/**
	 * @return the validationReferenceColumn
	 */
	public ColumnLocalId getValidationReferenceColumn() {
		return validationReferenceColumn;
	}

	@Override
	public boolean isInheritable() {
		return true;
	}

	
	
}
